package com.paypal.hybris.backoffice.action.order.capture;

import com.hybris.backoffice.widgets.notificationarea.NotificationService;
import com.hybris.cockpitng.actions.ActionContext;
import com.hybris.cockpitng.actions.ActionResult;
import com.hybris.cockpitng.actions.CockpitAction;
import com.hybris.cockpitng.engine.impl.AbstractComponentWidgetAdapterAware;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.OrderModel;
import de.hybris.platform.processengine.BusinessProcessService;
import de.hybris.platform.servicelayer.model.ModelService;

import javax.annotation.Resource;


public class PayPalCaptureAction extends AbstractComponentWidgetAdapterAware implements
    CockpitAction<OrderModel, OrderModel> {

    protected static final String MANUAL_PAYMENT_CAPTURE_SUCCESS = "action.manualpaymentcapture.success";
    protected static final String MANUAL_CAPTURE_PAYMENT_EVENT = "ManualCapturePaymentEvent";
    protected static final String SOCKET_OUT_CONTEXT = "paypalCaptureContext";
    private static final String ACCEPTED_STATUS = "ACCEPTED";
    @Resource
    private BusinessProcessService businessProcessService;
    @Resource
    private ModelService modelService;
    @Resource
    private NotificationService notificationService;

    public PayPalCaptureAction() {
        //default constructor
    }

    public ActionResult<OrderModel> perform(ActionContext<OrderModel> actionContext) {
        sendOutput(SOCKET_OUT_CONTEXT, actionContext.getData());

        return new ActionResult<>(ActionResult.SUCCESS);
    }

    public boolean canPerform(ActionContext<OrderModel> ctx) {
        OrderModel order = ctx.getData();
        return order != null && OrderStatus.PAYMENT_NOT_CAPTURED.equals(order.getStatus())
                && isOrderHasUncancelledTransactions(order);
    }

    public boolean isOrderHasUncancelledTransactions(OrderModel orderModel) {
        return orderModel.getPaymentTransactions().stream()
                .flatMap(paymentTransactionModel -> paymentTransactionModel.getEntries().stream())
                .anyMatch(paymentTransactionEntryModel -> paymentTransactionEntryModel.getTransactionStatus().equalsIgnoreCase(ACCEPTED_STATUS));
    }

    public boolean needsConfirmation(ActionContext<OrderModel> ctx) {
        return false;
    }

    public String getConfirmationMessage(ActionContext<OrderModel> ctx) {
        return null;
    }
}
