package com.paypal.hybris.b2bservice;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.cronjob.model.JobModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.servicelayer.cronjob.CronJobService;
import de.hybris.platform.servicelayer.keygenerator.KeyGenerator;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.type.TypeService;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalB2BAcceleratorScheduleOrderServiceTest {

    @InjectMocks
    private PayPalB2BAcceleratorScheduleOrderService unit;

    @Mock
    private ModelService modelService;
    @Mock
    private CartService cartService;
    @Mock
    private CronJobService cronJobService;
    @Mock
    private TypeService typeService;
    @Mock
    private KeyGenerator keyGenerator;
    @Mock
    CartModel cartModel;
    @Mock
    AddressModel deliveryAddress;
    @Mock
    AddressModel paymentAddress;
    @Mock
    PayPalCreditCardPaymentInfoModel paymentInfo;
    @Mock
    CartToOrderCronJobModel cartToOrderCronJobModel;
    @Mock
    JobModel jobModel;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldCreateOrderFromCartCronJob() {
        when(modelService.clone(paymentInfo)).thenReturn(paymentInfo);
        when(modelService.create(CartToOrderCronJobModel.class)).thenReturn(cartToOrderCronJobModel);
        when(cartService.clone(any(), any(), any(), any())).thenReturn(cartModel);
        when(cronJobService.getJob(any())).thenReturn(jobModel);
        when(typeService.getComposedTypeForClass(any())).thenReturn(null);
        when(keyGenerator.generate()).thenReturn(StringUtils.EMPTY);

        CartToOrderCronJobModel result = unit
                .createOrderFromCartCronJob(cartModel, deliveryAddress, paymentAddress, paymentInfo, new ArrayList<>());

        verify(paymentInfo).setDuplicate(true);
        verify(modelService).create(CartToOrderCronJobModel.class);
        assertEquals(cartToOrderCronJobModel, result);
    }

}
