package com.paypal.hybris.actions;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.b2bacceleratorservices.model.process.ReplenishmentProcessModel;
import de.hybris.platform.commerceservices.util.GuidKeyGenerator;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.processengine.helpers.ProcessParameterHelper;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.type.TypeService;
import de.hybris.platform.servicelayer.user.UserService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Matchers.any;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalCloneCartActionTest {
    @InjectMocks
    private PayPalCloneCartAction payPalCloneCartAction;
    @Mock
    private UserService userService;
    @Mock
    private CartService cartService;

    @Mock
    private TypeService typeService;

    @Mock
    private GuidKeyGenerator guidKeyGenerator;

    @Mock
    private ModelService modelService;

    @Mock
    private ProcessParameterHelper processParameterHelper;
    @Mock
    ReplenishmentProcessModel mockProcess;
    @Mock
    CartToOrderCronJobModel mockCartToOrderCronJobModel;
    @Mock
    CartModel mockCartModel;
    @Mock
    UserModel mockUserModel;
    @Mock
    CartModel mockReturnedCartModel;
    @Mock
    PayPalCreditCardPaymentInfoModel mockPayPalCreditCardPaymentInfoModel;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);
        when(mockProcess.getCartToOrderCronJob()).thenReturn(mockCartToOrderCronJobModel);
    }

    @Test
    public void shouldExecuteActionWithoutExceptions() {
        when(mockCartToOrderCronJobModel.getCart()).thenReturn(mockCartModel);
        when(mockCartModel.getUser()).thenReturn(mockUserModel);
        when(cartService.clone(any(), any(), any(), any())).thenReturn(mockReturnedCartModel);
        when(guidKeyGenerator.generate()).thenReturn(new Object());
        when(mockCartToOrderCronJobModel.getPaymentInfo()).thenReturn(mockPayPalCreditCardPaymentInfoModel);
        when(modelService.clone(any())).thenReturn(mockPayPalCreditCardPaymentInfoModel);

        payPalCloneCartAction.executeAction(mockProcess);

        verify(mockProcess, times(1)).getCartToOrderCronJob();
        verify(mockCartModel, times(1)).getUser();
        verify(cartService, times(1)).clone(any(), any(), any(), any());
        verify(modelService, times(1)).clone(any());
    }

    @Test(expected = Exception.class)
    public void shouldThrowExceptionWhenCartIsNull() {
        when(mockCartToOrderCronJobModel.getCart()).thenReturn(null);
        payPalCloneCartAction.executeAction(mockProcess);
    }
}
