package com.paypal.hybris.actions;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.core.service.PayPalCommerceCheckoutService;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.b2bacceleratorservices.model.process.ReplenishmentProcessModel;
import de.hybris.platform.commerceservices.impersonation.ImpersonationService;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.payment.dto.TransactionStatus;
import de.hybris.platform.payment.model.PaymentTransactionEntryModel;
import de.hybris.platform.processengine.action.AbstractSimpleDecisionAction;
import de.hybris.platform.processengine.helpers.ProcessParameterHelper;
import de.hybris.platform.processengine.model.BusinessProcessParameterModel;
import de.hybris.platform.servicelayer.model.ModelService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

import static org.junit.Assert.assertEquals;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;


@UnitTest
public class PayPalAuthorizePaymentActionTest {
    private static final String PAYPAL = "paypal";
    private static final String CART = "cart";
    @InjectMocks
    private PayPalAuthorizePaymentAction unit;
    @Mock
    private ModelService modelService;
    @Mock
    private ProcessParameterHelper processParameterHelper;
    @Mock
    private ImpersonationService impersonationService;
    @Mock
    private PayPalCommerceCheckoutService commerceCheckoutService;
    @Mock
    ReplenishmentProcessModel mockProcess;
    @Mock
    CartToOrderCronJobModel mockCartToOrderCronJobModel;
    @Mock
    CartModel mockCartModel;
    @Mock
    UserModel mockUserModel;
    @Mock
    PayPalCreditCardPaymentInfoModel mockPayPalCreditCardPaymentInfoModel;
    @Mock
    BusinessProcessParameterModel parameterModel;
    @Mock
    PaymentTransactionEntryModel paymentTransactionEntryModel;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        when(mockProcess.getCartToOrderCronJob()).thenReturn(mockCartToOrderCronJobModel);
        when(mockCartToOrderCronJobModel.getCart()).thenReturn(mockCartModel);
        when(mockCartModel.getUser()).thenReturn(mockUserModel);
    }

    @Test
    public void shouldReturnOkTransitionForNonCreditCardPaymentInfoModel() throws Throwable {
        when(processParameterHelper.getProcessParameterByName(mockProcess, CART)).thenReturn(parameterModel);
        when(parameterModel.getValue()).thenReturn(mockCartModel);
        when(impersonationService.executeInContext(any(), any())).thenAnswer(new Answer<Object>() {
            @Override
            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ((ImpersonationService.Executor<?, ?>) invocationOnMock.getArguments()[1]).execute();
            }
        });

        assertEquals(AbstractSimpleDecisionAction.Transition.OK, unit.executeAction(mockProcess));
        verify(modelService).refresh(mockCartModel);
    }

    @Test
    public void shouldReturnOkTransitionForCreditCardPaymentInfoModel() throws Throwable {
        when(mockCartModel.getPaymentInfo()).thenReturn(mockPayPalCreditCardPaymentInfoModel);
        when(parameterModel.getValue()).thenReturn(mockCartModel);
        when(processParameterHelper.getProcessParameterByName(mockProcess, CART)).thenReturn(parameterModel);
        when(impersonationService.executeInContext(any(), any())).thenAnswer(new Answer<Object>() {
            @Override
            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ((ImpersonationService.Executor<?, ?>) invocationOnMock.getArguments()[1]).execute();
            }
        });

        when(commerceCheckoutService.getPaymentProvider()).thenReturn(PAYPAL);
        when(commerceCheckoutService.authorizePayment(any())).thenReturn(paymentTransactionEntryModel);
        when(paymentTransactionEntryModel.getTransactionStatus()).thenReturn(TransactionStatus.ACCEPTED.name());

        assertEquals(AbstractSimpleDecisionAction.Transition.OK, unit.executeAction(mockProcess));
        verify(modelService).refresh(mockCartModel);
        verify(commerceCheckoutService).authorizePayment(any());
    }

    @Test
    public void shouldReturnNotOkTransitionWhenTransactionRejected() throws Throwable {
        when(mockCartModel.getPaymentInfo()).thenReturn(mockPayPalCreditCardPaymentInfoModel);
        when(parameterModel.getValue()).thenReturn(mockCartModel);
        when(processParameterHelper.getProcessParameterByName(mockProcess, CART)).thenReturn(parameterModel);
        when(impersonationService.executeInContext(any(), any())).thenAnswer(new Answer<Object>() {
            @Override
            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return ((ImpersonationService.Executor<?, ?>) invocationOnMock.getArguments()[1]).execute();
            }
        });

        when(commerceCheckoutService.getPaymentProvider()).thenReturn(PAYPAL);
        when(commerceCheckoutService.authorizePayment(any())).thenReturn(paymentTransactionEntryModel);
        when(paymentTransactionEntryModel.getTransactionStatus()).thenReturn(TransactionStatus.REJECTED.name());

        assertEquals(AbstractSimpleDecisionAction.Transition.NOK, unit.executeAction(mockProcess));
        verify(modelService).refresh(mockCartModel);
        verify(commerceCheckoutService).authorizePayment(any());
    }

}
