package com.paypal.hybris.b2bservice;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.b2bacceleratorservices.orderscheduling.impl.B2BAcceleratorScheduleOrderService;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.cronjob.model.TriggerModel;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import java.util.List;


public class PayPalB2BAcceleratorScheduleOrderService extends B2BAcceleratorScheduleOrderService {

    @Override
    public CartToOrderCronJobModel createOrderFromCartCronJob(final CartModel cart, final AddressModel deliveryAddress,
        final AddressModel paymentAddress, final PaymentInfoModel paymentInfo, final List<TriggerModel> triggers){
        PaymentInfoModel paymentInfoForJob = paymentInfo;
        if (paymentInfo instanceof PayPalCreditCardPaymentInfoModel) {
            paymentInfoForJob = getModelService().clone(paymentInfo);
            paymentInfoForJob.setDuplicate(true);
        }
        return super.createOrderFromCartCronJob(cart, deliveryAddress, paymentAddress, paymentInfoForJob, triggers);
    }


}
