package com.paypal.hybris.b2bfacade.impl;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalCreditCardFacade;
import de.hybris.platform.b2bacceleratorservices.customer.B2BCustomerAccountService;
import de.hybris.platform.b2bacceleratorservices.customer.impl.DefaultB2BCustomerAccountService;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.core.model.user.UserModel;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;

import java.util.List;

public class DefaultPayPalB2BCreditCardFacade extends DefaultPayPalCreditCardFacade {

    private B2BCustomerAccountService b2BCustomerAccountService;

    @Override
    public void deleteCreditCardFromPayPal(String paymentMethodId) {
        final UserModel userModel = userService.getCurrentUser();
        final PayPalCreditCardPaymentInfoModel selectedPaymentInfo = (PayPalCreditCardPaymentInfoModel)
                customerAccountService.getCreditCardPaymentInfoForCode((CustomerModel) userModel, paymentMethodId);

        super.deleteCreditCardFromPayPal(paymentMethodId);
        cancelReplenishmentsBySubscriptionId(selectedPaymentInfo.getSubscriptionId(), userModel);

    }

    private void cancelReplenishmentsBySubscriptionId(String subscriptionId, UserModel userModel) {
        List<? extends CartToOrderCronJobModel> cartToOrderCronJobsForUser = b2BCustomerAccountService.getCartToOrderCronJobsForUser(userModel);

        cartToOrderCronJobsForUser.stream()
                .filter(cartToOrderCronJobModel -> ((PayPalCreditCardPaymentInfoModel) cartToOrderCronJobModel.getPaymentInfo())
                        .getSubscriptionId().equals(subscriptionId))
                .forEach(jobModel -> {
                    jobModel.setActive(false);
                    modelService.save(jobModel);
                });
    }

    @Override
    public void deleteCreditCardFromWebhookEvent(String subscriptionId) {
        getPaymentInfoService().getCreditCardBySubscriptionId(subscriptionId)
                .ifPresent(ccPaymentInfo -> {
                    CustomerModel customerModel = (CustomerModel) ccPaymentInfo.getUser();
                    cancelReplenishmentsBySubscriptionId(subscriptionId, customerModel);
                    deleteCCPaymentAndSetLastDefault(ccPaymentInfo, customerModel);
                });
    }


    public void setB2BCustomerAccountService(DefaultB2BCustomerAccountService b2BCustomerAccountService) {
        this.b2BCustomerAccountService = b2BCustomerAccountService;
    }

}
