/**
 *
 */
package com.paypal.hybris.actions;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.platform.b2bacceleratorservices.model.process.ReplenishmentProcessModel;
import de.hybris.platform.core.enums.OrderStatus;
import de.hybris.platform.core.model.order.CartEntryModel;
import de.hybris.platform.core.model.order.CartModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.order.CartService;
import de.hybris.platform.orderscheduling.model.CartToOrderCronJobModel;
import de.hybris.platform.processengine.action.AbstractProceduralAction;
import de.hybris.platform.servicelayer.keygenerator.KeyGenerator;
import de.hybris.platform.servicelayer.type.TypeService;
import de.hybris.platform.servicelayer.user.UserService;

import java.util.Collections;

public class PayPalCloneCartAction extends AbstractProceduralAction<ReplenishmentProcessModel> {

    private static final String CART = "cart";
    private CartService cartService;
    private TypeService typeService;
    private UserService userService;
    private KeyGenerator guidKeyGenerator;

    @Override
    public void executeAction(final ReplenishmentProcessModel process) {
        final CartToOrderCronJobModel cartToOrderCronJob = process.getCartToOrderCronJob();
        final CartModel cronJobCart = cartToOrderCronJob.getCart();
        getUserService().setCurrentUser(cronJobCart.getUser());
        final CartModel clone = getCartService().clone(getTypeService().getComposedTypeForClass(CartModel.class),
            getTypeService().getComposedTypeForClass(CartEntryModel.class), cronJobCart,
            getGuidKeyGenerator().generate().toString());
        clone.setPaymentAddress(cartToOrderCronJob.getPaymentAddress());
        clone.setDeliveryAddress(cartToOrderCronJob.getDeliveryAddress());
        clone.setPaymentInfo(clonePaymentInfo(cartToOrderCronJob.getPaymentInfo()));
        clone.setStatus(OrderStatus.CREATED);
        clone.setAllPromotionResults(Collections.emptySet());
        clone.setPaymentTransactions(Collections.emptyList());
        clone.setPermissionResults(Collections.emptyList());
        clone.setGuid(getGuidKeyGenerator().generate().toString());
        this.modelService.save(clone);
        processParameterHelper.setProcessParameter(process, CART, clone);
    }

    protected PaymentInfoModel clonePaymentInfo(final PaymentInfoModel originalPaymentInfo) {
        if (originalPaymentInfo instanceof PayPalCreditCardPaymentInfoModel) {
            final PaymentInfoModel clonedPaymentInfo = this.modelService.clone(originalPaymentInfo);
            clonedPaymentInfo.setOriginal(originalPaymentInfo);
            this.modelService.save(clonedPaymentInfo);
            return clonedPaymentInfo;
        }
        return originalPaymentInfo;
    }

    public CartService getCartService() {
        return cartService;
    }

    public void setCartService(CartService cartService) {
        this.cartService = cartService;
    }

    public TypeService getTypeService() {
        return typeService;
    }

    public void setTypeService(TypeService typeService) {
        this.typeService = typeService;
    }

    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public KeyGenerator getGuidKeyGenerator() {
        return guidKeyGenerator;
    }

    public void setGuidKeyGenerator(KeyGenerator guidKeyGenerator) {
        this.guidKeyGenerator = guidKeyGenerator;
    }
}
