package com.paypalocc.validators;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.validation.Errors;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;

@UnitTest
public class PayPalPageTypeValidatorTest {

	private static final String VALID_TYPE = "cart";
	private static final String INVALID_TYPE = "invalidType";
	private static final String INCORRECT_PAGE_TYPE = "Incorrect pageType parameter";

	@Mock
	private Errors errors;
	@InjectMocks
	private PayPalPageTypeValidator unit;

	@Before
	public void setUp() {
		MockitoAnnotations.initMocks(this);
	}

	@Test
	public void shouldSupportRegistrationFormObject() {
		assertThat(unit.supports(String.class)).isEqualTo(Boolean.TRUE);
	}

	@Test
	public void shouldValidateExistingType() {

		unit.validate(VALID_TYPE, errors);

		verify(errors, never()).rejectValue(VALID_TYPE, INCORRECT_PAGE_TYPE);
	}

	@Test
	public void shouldNotValidateNotExistingType() {

		unit.validate(INVALID_TYPE, errors);

		verify(errors).reject(INVALID_TYPE, INCORRECT_PAGE_TYPE);
	}

}
