/**
 *
 */
package com.paypalocc.validators;

import com.paypal.enums.PayPalPageType;
import org.apache.log4j.Logger;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

import java.util.Locale;

public class PayPalPageTypeValidator implements Validator {

    private static final String INCORRECT_PAGE_TYPE = "Incorrect pageType parameter";

    private static final Logger LOG = Logger.getLogger(PayPalPageTypeValidator.class);

    @Override
    public boolean supports(Class<?> aClass) {
        return String.class.equals(aClass);
    }

    @Override
    public void validate(Object object, Errors errors) {
        final String pageType = (String) object;
        try {
            PayPalPageType.valueOf(pageType.toUpperCase(Locale.US));
        } catch (IllegalArgumentException exception) {
            errors.reject(pageType, INCORRECT_PAGE_TYPE);
            LOG.error(INCORRECT_PAGE_TYPE, exception);
        }
    }
}