package com.paypalocc.controllers;

import com.paypal.enums.PayPalPageType;
import com.paypal.hybris.data.PayPalSDKData;
import com.paypal.hybris.data.ws.PayPalSDKWsDTO;
import com.paypal.hybris.facade.facades.PayPalSDKFacade;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping(value = "/{baseSiteId}/paypal")
public class PayPalSdkController extends PayPalBaseController{

    private static final String LOGIN_PAGE_TYPE = "login";
    private static final String MY_ACCOUNT_PAGE_TYPE = "account";

    @Resource(name = "payPalSDKFacade")
    PayPalSDKFacade payPalSDKFacade;

    @GetMapping("/sdk")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(summary = " Get the Paypal SDK data")
    public PayPalSDKWsDTO getPayPalSDKData() {
        final PayPalSDKData payPalSDKData = payPalSDKFacade.getPayPalSDKData();
        return getDataMapper().map(payPalSDKData, PayPalSDKWsDTO.class);
    }
    @GetMapping("/sdk/{pageType}")
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdParam
    @Operation(summary = " Get the Paypal SDK data for page")
    public PayPalSDKWsDTO getPayPalSDKDataForPage(
            @Parameter(description = "PageType identifier.", required = true) @PathVariable final String pageType) {
        PayPalSDKData payPalSDKData;
        if (LOGIN_PAGE_TYPE.equals(pageType)) {
            payPalSDKData = payPalSDKFacade.getPayPalSDKData(PayPalPageType.LOGIN);
        } else if (MY_ACCOUNT_PAGE_TYPE.equals(pageType)){
            payPalSDKData = payPalSDKFacade.getPayPalSDKData(PayPalPageType.ACCOUNT);
        } else {
            payPalSDKData = payPalSDKFacade.getPayPalSDKData();
        }
        return getDataMapper().map(payPalSDKData, PayPalSDKWsDTO.class);
    }


}
