/*

 */
package com.paypalb2bocc.controllers;

import com.google.gson.Gson;
import com.paypal.hybris.b2bfacade.PayPalB2BRegistrationUserFacade;
import com.paypal.hybris.core.model.PaypalAccessTokenModel;
import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.core.service.PaypalAccessTokenService;
import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.PayPalConnectB2BRegisterData;
import com.paypal.hybris.data.PayPalConnectUserData;
import com.paypal.hybris.data.PayPalUserExistB2BData;
import com.paypal.hybris.data.ws.PayPalB2BConnectLoginWsData;
import com.paypal.hybris.data.ws.PayPalConnectB2BRegisterWsData;
import com.paypal.hybris.data.ws.PayPalConnectB2BWsData;
import com.paypal.hybris.data.ws.PayPalConnectTokenB2BWsData;
import com.paypal.hybris.data.ws.RegisterUserResponseWsDTO;
import com.paypal.hybris.facade.exception.PaypalAccessTokenNotFoundException;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalCreditCardFacade;
import com.paypal.hybris.facade.facades.PayPalCustomerFacade;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import com.paypalocc.controllers.PayPalBaseController;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.commerceservices.customer.DuplicateUidException;
import de.hybris.platform.site.BaseSiteService;
import de.hybris.platform.webservicescommons.cache.CacheControl;
import de.hybris.platform.webservicescommons.cache.CacheControlDirective;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdAndUserIdParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import com.paypal.hybris.facade.facades.PayPalConnectWithPayPalNotificationFacade;

import javax.annotation.Resource;

import static com.paypalb2bocc.constants.Paypalb2boccWebConstants.PAYPAL_OCC_REWRITE_OVERLAPPING_BASE_PAYPAL_CONNECT_PATH;

@RestController
@RequestMapping(value = PAYPAL_OCC_REWRITE_OVERLAPPING_BASE_PAYPAL_CONNECT_PATH)
@CacheControl(directive = CacheControlDirective.NO_CACHE)
@Tag(name = "PayPal Connect")
public class PayPalB2BConnectController extends PayPalBaseController {

    private final Gson gson = new Gson();

    @Resource(name = "payPalCustomerFacade")
    private PayPalCustomerFacade payPalCustomerFacade;

    @Resource(name = "payPalCreditCardFacade")
    private PayPalCreditCardFacade payPalCreditCardFacade;

    @Resource(name = "payPalConnectService")
    private PayPalConnectService payPalConnectService;

    @Resource(name = "baseSiteService")
    private BaseSiteService baseSiteService;

    @Resource(name = "payPalCustomerAccountService")
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Resource(name = "payPalB2BRegistrationUserFacade")
    private PayPalB2BRegistrationUserFacade registrationUserFacade;

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService defaultPayPalConfigurationService;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "payPalRegistrationUserFacade")
    private PayPalRegistrationUserFacade userFacade;

    @Resource
    private PaypalAccessTokenService paypalAccessTokenService;

    @Resource
    private PayPalConnectWithPayPalNotificationFacade payPalConnectWithPayPalNotificationFacade;

    @Secured({"ROLE_CLIENT", "ROLE_CUSTOMERGROUP", "ROLE_GUEST", "ROLE_CUSTOMERMANAGERGROUP", "ROLE_TRUSTED_CLIENT",
            "ROLE_ANONYMOUS"})
    @PostMapping(value = "/exchange")
    @ResponseStatus(HttpStatus.OK)
    @Operation(operationId = "exchange authorization code", summary = "exchange authorization code to access token")
    @ApiBaseSiteIdAndUserIdParam
    public PayPalConnectB2BWsData exchangeAuthorizationCode(
            @Parameter(description = "JSON object which contains authorization code", required = true)
            @RequestBody PayPalConnectTokenB2BWsData payPalConnectTokenB2BWsData) {
        final PayPalConnectB2BWsData connectWsData = new PayPalConnectB2BWsData();
        final String accessToken = payPalConnectService
                .exchangeAuthorizationCodeToAccessToken(payPalConnectTokenB2BWsData.getAuthorizationCode());

        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);
        final String email = userFacade.getEmailFromPayPalUserData(userData);
        final PayPalUserExistB2BData existB2BData = registrationUserFacade.isCustomerExistAndApprovedByUID(email);
        if (existB2BData.getIsExist()) {
            connectWsData.setShouldSaveAddress(!payPalCustomerFacade.isPayPalAddressPresent(email, userData.getAddress()));
            connectWsData.setShouldSavePaymentInfo(!payPalCustomerFacade.isPayPalPaymentMethodPresent(email, userData));
        } else {
            connectWsData.setShouldSaveAddress(true);
            connectWsData.setShouldSavePaymentInfo(defaultPayPalConfigurationService.isPayPalVaultFlowEnabled());
        }
        connectWsData.setEmail(email);
        connectWsData.setBaseSiteName(baseSiteService.getCurrentBaseSite().getName());
        connectWsData.setIsUserAlreadyConnectPayPalAccount(payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id()));
        connectWsData.setPayerId(userData.getPayer_id());
        boolean isLoginFlowAndUserApproved = existB2BData.getIsApproved() && existB2BData.getIsExist();
        boolean isRegistrationFlow = !existB2BData.getIsExist();
        if (isLoginFlowAndUserApproved || isRegistrationFlow) {
            String accessTokenGuid = paypalAccessTokenService.savePaypalAccessToken(accessToken);
            connectWsData.setAccessTokenGuid(accessTokenGuid);
        }
        connectWsData.setIsRegistered(existB2BData.getIsExist());
        connectWsData.setIsApproved(existB2BData.getIsApproved());
        return connectWsData;
    }

    @Secured({"ROLE_CLIENT", "ROLE_CUSTOMERGROUP", "ROLE_GUEST", "ROLE_CUSTOMERMANAGERGROUP", "ROLE_TRUSTED_CLIENT",
            "ROLE_ANONYMOUS"})
    @PostMapping(value = "/register")
    @ResponseStatus(HttpStatus.OK)
    @Operation(operationId = "register endpoint for connect with PayPal", summary = "register connect with paypal user")
    @ApiBaseSiteIdAndUserIdParam
    public RegisterUserResponseWsDTO doRegister(
            @Parameter(description = "Registration data", required = true) @RequestBody final PayPalConnectB2BRegisterWsData registerData)
            throws DuplicateUidException, PaypalAccessTokenNotFoundException {
        String payerId = registrationUserFacade.registerB2BPayPalUser(
                getDataMapper().map(registerData, PayPalConnectB2BRegisterData.class));
        return GenericBuilder.of(RegisterUserResponseWsDTO::new)
                .with(RegisterUserResponseWsDTO::setPayerId, payerId)
                .build();
    }


    @Secured({"ROLE_CLIENT", "ROLE_CUSTOMERGROUP", "ROLE_GUEST", "ROLE_CUSTOMERMANAGERGROUP", "ROLE_TRUSTED_CLIENT",
            "ROLE_ANONYMOUS"})
    @PostMapping(value = "/login")
    @ResponseStatus(HttpStatus.OK)
    @Operation(operationId = "login endpoint for connect with PayPal", summary = "Generate login data for user by accessToken")
    @ApiBaseSiteIdAndUserIdParam
    public PayPalB2BConnectLoginWsData login(
            @Parameter(description = "JSON object which contains accessToken", required = true)
            @RequestBody PayPalConnectTokenB2BWsData payPalConnectTokenB2BWsData) throws PaypalAccessTokenNotFoundException {
        String accessTokenGuid = payPalConnectTokenB2BWsData.getAccessTokenGuid();
        String accessToken = paypalAccessTokenService.getPaypalAccessToken(accessTokenGuid)
                .map(PaypalAccessTokenModel::getAccessToken)
                .orElseThrow(PaypalAccessTokenNotFoundException::new);
        final PayPalConnectUserData userData = payPalConnectService
                .getUserDataByAccessToken(accessToken);
        final String email = userFacade.getEmailFromPayPalUserData(userData);
        final CustomerData customer = payPalCustomerAccountService.getCustomerDataByUid(email);
        if (!payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id())) {
            userFacade.setPayerIdToUser(email, userData.getPayer_id());
            payPalConnectWithPayPalNotificationFacade.sendLinkCustomerEmailNotification(email);
        }
        payPalCustomerAccountService.setAccessTokenForCustomer(accessTokenGuid, userData.getPayer_id());
        final PayPalB2BConnectLoginWsData loginData = new PayPalB2BConnectLoginWsData();
        loginData.setLogin(customer.getUid());
        loginData.setAccessTokenGuid(accessTokenGuid);
        return loginData;
    }

}
