package com.paypal.hybris.b2baddon.actions;

import com.paypal.hybris.core.model.PayPalCreditCardPaymentInfoModel;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.b2b.model.B2BCustomerModel;
import de.hybris.platform.b2b.model.B2BRegistrationModel;
import de.hybris.platform.b2b.model.B2BUnitModel;
import de.hybris.platform.core.model.order.payment.PaymentInfoModel;
import de.hybris.platform.core.model.user.AddressModel;
import de.hybris.platform.core.model.user.CustomerModel;
import de.hybris.platform.core.model.user.TitleModel;
import de.hybris.platform.servicelayer.model.ModelService;
import de.hybris.platform.servicelayer.user.PasswordEncoderConstants;
import de.hybris.platform.servicelayer.user.UserService;
import de.hybris.platform.workflow.WorkflowAttachmentService;
import de.hybris.platform.workflow.exceptions.WorkflowTerminatedException;
import de.hybris.platform.workflow.model.WorkflowActionModel;
import de.hybris.platform.workflow.model.WorkflowDecisionModel;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

import java.util.List;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;
import static org.mockito.Mockito.when;

@UnitTest
public class PayPalRegistrationApprovedAutomatedWorkflowTemplateJobTest {

    private static final String UID = "uid";
    private static final String NAME = "name";
    private static final String PAYER_ID = "payerId";
    private static final String ENCODED_PASSWORD = "encodedPassword";
    @Spy
    @InjectMocks
    private PayPalRegistrationApprovedAutomatedWorkflowTemplateJob unit;
    @Mock
    private WorkflowAttachmentService workflowAttachmentService;
    @Mock
    private WorkflowActionModel workflowAction;
    @Mock
    private B2BRegistrationModel b2BRegistrationModel;
    @Mock
    private CustomerModel customerModel;
    @Mock
    private B2BCustomerModel b2BCustomerModel;
    @Mock
    private ModelService modelService;
    @Mock
    private WorkflowDecisionModel workflowDecisionModel;
    @Mock
    private B2BUnitModel b2BUnitModel;
    @Mock
    private TitleModel titleModel;
    @Mock
    private UserService userService;
    @Mock
    private PaymentInfoModel paymentInfoModel;
    @Mock
    private PayPalCreditCardPaymentInfoModel payPalCreditCardPaymentInfoModel;
    @Mock
    private AddressModel addressModel;


    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        when(workflowAttachmentService.getAttachmentsForAction(workflowAction, B2BRegistrationModel.class.getName()))
                .thenReturn(List.of(b2BRegistrationModel));
        when(b2BRegistrationModel.getCustomer()).thenReturn(customerModel);
        when(workflowAction.getDecisions()).thenReturn(List.of(workflowDecisionModel));
    }

    @Test(expected = WorkflowTerminatedException.class)
    public void shouldThrowWorkflowTerminatedExceptionWhenB2BUnitIsNull() {
        unit.perform(workflowAction);
    }

    @Test
    public void shouldSaveB2BCustomerAndReturnDecision() {
        when(b2BRegistrationModel.getDefaultB2BUnit()).thenReturn(b2BUnitModel);
        doReturn(b2BCustomerModel).when(unit).createB2BCustomerModel(customerModel, b2BRegistrationModel);

        WorkflowDecisionModel decision = unit.perform(workflowAction);

        verify(b2BRegistrationModel).setCustomer(b2BCustomerModel);
        verify(modelService).saveAll(b2BCustomerModel, b2BRegistrationModel);
        assertEquals(workflowDecisionModel, decision);
    }

    @Test
    public void shouldCreateB2BCustomerModelWhenPasswordNotNullAndHaveNoPaymentInfosAndAddresses() {
        when(modelService.create(B2BCustomerModel.class)).thenReturn(b2BCustomerModel);
        when(customerModel.getUid()).thenReturn(UID);
        when(customerModel.getName()).thenReturn(NAME);
        when(customerModel.getTitle()).thenReturn(titleModel);
        when(customerModel.getPayPalPayerId()).thenReturn(PAYER_ID);
        when(customerModel.getEncodedPassword()).thenReturn(ENCODED_PASSWORD);
        when(customerModel.isPasswordForSingleAuthenticationActive()).thenReturn(true);
        when(customerModel.getPaymentInfos()).thenReturn(List.of());
        when(customerModel.getAddresses()).thenReturn(List.of());
        when(b2BRegistrationModel.getDefaultB2BUnit()).thenReturn(b2BUnitModel);

        B2BCustomerModel createdB2BCustomerModel = unit.createB2BCustomerModel(customerModel, b2BRegistrationModel);

        verify(b2BCustomerModel).setUid(UID);
        verify(b2BCustomerModel).setEmail(UID);
        verify(b2BCustomerModel).setTitle(titleModel);
        verify(b2BCustomerModel).setPayPalPayerId(PAYER_ID);
        verify(modelService).remove(customerModel);
        assertNotNull(createdB2BCustomerModel);
    }

    @Test
    public void shouldCreateB2BCustomerModelWhenPasswordIsNullAndHavePaymentInfosAndAddresses() {
        when(modelService.create(B2BCustomerModel.class)).thenReturn(b2BCustomerModel);
        when(customerModel.getUid()).thenReturn(UID);
        when(customerModel.getName()).thenReturn(NAME);
        when(customerModel.getTitle()).thenReturn(titleModel);
        when(customerModel.getPayPalPayerId()).thenReturn(PAYER_ID);
        when(customerModel.isPasswordForSingleAuthenticationActive()).thenReturn(true);
        when(customerModel.getPaymentInfos()).thenReturn(List.of(paymentInfoModel, payPalCreditCardPaymentInfoModel));
        when(customerModel.getAddresses()).thenReturn(List.of(addressModel));
        when(b2BRegistrationModel.getDefaultB2BUnit()).thenReturn(b2BUnitModel);
        when(modelService.clone(payPalCreditCardPaymentInfoModel)).thenReturn(payPalCreditCardPaymentInfoModel);
        when(modelService.clone(addressModel)).thenReturn(addressModel);

        B2BCustomerModel createdB2BCustomerModel = unit.createB2BCustomerModel(customerModel, b2BRegistrationModel);

        verify(b2BCustomerModel).setUid(UID);
        verify(b2BCustomerModel).setEmail(UID);
        verify(b2BCustomerModel).setTitle(titleModel);
        verify(b2BCustomerModel).setPayPalPayerId(PAYER_ID);
        verify(modelService).remove(customerModel);
        verify(modelService).clone(payPalCreditCardPaymentInfoModel);
        verify(b2BCustomerModel).setDefaultPaymentInfo(payPalCreditCardPaymentInfoModel);
        verify(b2BCustomerModel).setDefaultShipmentAddress(addressModel);
        verify(b2BCustomerModel).setDefaultPaymentAddress(addressModel);
        verifyNoInteractions(paymentInfoModel);
        verify(userService).setPassword(b2BCustomerModel, StringUtils.EMPTY, PasswordEncoderConstants.DEFAULT_ENCODING);
        assertNotNull(createdB2BCustomerModel);
    }

}
