package com.paypal.hybris.b2baddon;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.core.Registry;
import de.hybris.platform.jalo.JaloSession;
import de.hybris.platform.jalo.user.User;
import de.hybris.platform.util.RedeployUtilities;
import de.hybris.platform.util.Utilities;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.when;

@UnitTest
public class Paypalb2baddonStandaloneTest {

    private static final String SESSION_ID = "sessionID";

    @Mock
    private JaloSession jaloSession;

    @Mock
    private User user;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldRun() {
        try (MockedStatic<JaloSession> jaloSessionMockedStatic = mockStatic(JaloSession.class);
             MockedStatic<Registry> registryMockedStatic = mockStatic(Registry.class);
             MockedStatic<Utilities> utilitiesMockedStatic = mockStatic(Utilities.class);
             MockedStatic<RedeployUtilities> redeployUtilitiesMockedStatic = mockStatic(RedeployUtilities.class);
        ) {
            jaloSessionMockedStatic.when(JaloSession::getCurrentSession).thenReturn(jaloSession);

            when(jaloSession.getSessionID()).thenReturn(SESSION_ID);
            when(jaloSession.getUser()).thenReturn(user);


            Paypalb2baddonStandalone.main(new String[1]);

            registryMockedStatic.verify(Registry::activateStandaloneMode);
            registryMockedStatic.verify(Registry::activateMasterTenant);
            utilitiesMockedStatic.verify(Utilities::printAppInfo);
            redeployUtilitiesMockedStatic.verify(RedeployUtilities::shutdown);
        }
    }

}
