package com.paypal.hybris.b2baddon.renderer;


import com.paypal.hybris.core.service.impl.DefaultPayPalConfigurationService;
import de.hybris.platform.addonsupport.renderer.impl.DefaultAddOnCMSComponentRenderer;
import de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel;
import de.hybris.platform.spring.IgnoreTenantScopeMetadataResolver;
import org.springframework.context.annotation.ComponentScan;

import javax.annotation.Resource;
import javax.servlet.jsp.PageContext;
import java.util.Map;


@ComponentScan(basePackages = {
    "com.paypal.hybris.b2baddon.services"}, scopeResolver = IgnoreTenantScopeMetadataResolver.class)
public class PayPalB2bDefaultAddOnCMSComponentRenderer<C extends AbstractCMSComponentModel> extends
    DefaultAddOnCMSComponentRenderer<C> {

    private static final String CLIENT_ID = "clientId";
    private static final String INTENT = "intent";
    private static final String COMMIT = "commit";
    private static final String PAYPAL_SDK_URL = "paypalSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";

    @Resource(name = "payPalConfigurationService")
    private DefaultPayPalConfigurationService payPalConfigurationService;

    protected Map<String, Object> exposeVariables(final PageContext pageContext,
        @SuppressWarnings("unused") final C component)
    {
        final Map<String, Object> variables = getVariablesToExpose(pageContext, component);
        if (variables != null) {
            for (final Map.Entry<String, Object> entry : variables.entrySet()) {
                pageContext.setAttribute(entry.getKey(), entry.getValue(), getScopeForVariableName(entry.getKey()));
            }

            pageContext.setAttribute(CLIENT_ID, payPalConfigurationService.getClientID(),
                getScopeForVariableName(CLIENT_ID));
            pageContext.setAttribute(INTENT, payPalConfigurationService.getPayPalIntent(),
                getScopeForVariableName(INTENT));
            pageContext.setAttribute(COMMIT, payPalConfigurationService.isCommitEnabled(),
                getScopeForVariableName(COMMIT));
            pageContext.setAttribute(PAYPAL_SDK_URL, payPalConfigurationService.getPayPalSdkJsUrl(),
                getScopeForVariableName(PAYPAL_SDK_URL));
            pageContext.setAttribute(PARTNER_ATTRIBUTION_ID, payPalConfigurationService.getPayPalPartnerAttributionId(),
                getScopeForVariableName(PARTNER_ATTRIBUTION_ID));

        }
        return variables;
    }
}
