/*
 * [y] hybris Platform
 *
 * Copyright (c) 2017 SAP SE or an SAP affiliate company.  All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */

$(function () {
    if (window.opener != null && window.opener.PAYPAL !== undefined) {
        window.opener.location = window.location;
        window.opener.PAYPAL.apps.Checkout.closeFlow();
    }
    hideAllPayments();
    if (document.getElementsByName('paymentMethodSelection').length != 0) {
        document.getElementsByName('paymentMethodSelection')[0].checked = true;
    }
    checkoutPayments();
    showInfoMessageIfExist();
    $('input[name=paymentMethodSelection]').click(function () {
        checkoutPayments();
    });
    if ($('#whatIsPayPalLink>a').length > 0) {
        $('#whatIsPayPalLink>a').on('click', function () {
            const newwindow = window.open($(this).attr('href'), '', 'height=768,width=1280,menubar=no,status=no');
            if (window.focus) {
                newwindow.focus()
            }
            return false;
        });
    }
});

function showInfoMessageIfExist () {
    const key = 'savedPayPalPaymentMethodMessage';
    const message = localStorage.getItem(key);
    if (message != null) {
        ACC.paypalutil.handlePayPalClientInfoMessage(message);
        localStorage.removeItem(key);
    }
}

$("#placeOrderForm1").on("submit", function() {
    $("#placeOrder").prop('disabled', true);
    $("#placeOrderWithVenmo").prop('disabled', true);
});

function checkoutPayments() {
    const paymentMethodSelectionRadioChecked = 'input[name=paymentMethodSelection]:radio:checked';

    if ($(paymentMethodSelectionRadioChecked).val() === 'paypal') {
        $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).show();
        $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).show();
        $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.MARK_APPLE_PAY_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).hide();
        $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).hide();
    }
    if ($(paymentMethodSelectionRadioChecked).val() === 'applepay') {
        $(PAYPAL_CONSTANTS.MARK_APPLE_PAY_BUTTONS_CONTAINER).show();
        $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).hide();
        $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).hide();
        $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).hide();
        $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).hide();
    }
    if ($(paymentMethodSelectionRadioChecked).val() === 'hosted-fields') {
        $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).hide();
        $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.MARK_APPLE_PAY_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).show();
        $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).show();
        $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).hide();
    }
    if ($(paymentMethodSelectionRadioChecked).val() === 'venmo') {
        $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).hide();
        $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.MARK_APPLE_PAY_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).hide();
        $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).show();
    }
    if ($(paymentMethodSelectionRadioChecked).val() === 'lpm') {
        $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).show();
        $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).hide();
        $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.MARK_APPLE_PAY_BUTTONS_CONTAINER).hide();
        $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).hide();
        $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).hide();
        $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).hide();
    }
}

function onUseDeliveryAddressChange() {
    const checkbox = document.getElementById('useDeliveryAddress');
    const showIfEnabled = document.getElementById('selectedAddress');
    const showIfDisabled = document.getElementById('addressFields');
    if (checkbox?.checked) {
        showIfDisabled.hidden = true;
        showIfEnabled.hidden = false;
    } else {
        showIfEnabled.hidden = true;
        showIfDisabled.hidden = false;

    }
}

function hideAllPayments(){
    $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).hide();
    $(PAYPAL_CONSTANTS.PAYPAL_PAYMENT_SECTION).hide();
    $(PAYPAL_CONSTANTS.SAVE_PAYPAL_PAYMENT_INFO).hide();
    $(PAYPAL_CONSTANTS.SAVE_HOSTED_FIELD_PAYMENT_INFO).hide();
    $(PAYPAL_CONSTANTS.HOSTED_FIELDS_SECTION).hide();
    $(PAYPAL_CONSTANTS.VENMO_PAYMENT_SECTION).hide();
}
