ACC.paypalchekout = {

    _autoload: [
        ["showPayPalSelector", $('#mark-paypal-buttons-container').length !== 0],
        ["disableSavePaymentInfoCheckbox", $('#savePaymentInfoCheckbox').length !== 0],
        ["renderPayPalBtn", $('#mark-paypal-buttons-container').length !== 0, "showInfoMessageIfExist"]
    ],

    renderPayPalBtn: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise;
        try {
            if(isPayPalEnable) {
                payPalFundingOnBillingPage.filter(funding => ACC.paypalchekout.filterCardFunding(funding)).forEach(function (funding) {
                    ACC.paypalstandalonebutton.renderMarkButton(funding, ACC.paypalchekout.getContainerId(funding), PAYPAL_CONSTANTS.FLOWS.MARK_CHECKOUT, paypalButtonConfig);
                });
            }
        } catch (err) {
            ACC.paypalchekout.handleError("paypal.button.render.error" + err.message);
        }
    },

    handleError: function (message) {
        $("#errorMessage span").text(message);
    },

    getContainerId: function (funding) {
        return '#mark-' + funding + '-button-container';
    },

    showInfoMessageIfExist: function () {
        const key = 'savedInfoMessage';
        const message = localStorage.getItem(key);
        if (message != null) {
            ACC.paypalutil.handlePayPalClientInfoMessage(message);
            localStorage.removeItem(key);
        }
    },

    disableSavePaymentInfoCheckbox: function () {
        if (ACC.addons.paypalb2baddon.isChangePaymentButtonActive === "true") {
            $("#savePaymentInfoCheckbox").prop("disabled", true);
        }
    },

    showPayPalSelector: function () {
        var payPalButtonsContainer = $(PAYPAL_CONSTANTS.MARK_PAYPAL_BUTTONS_CONTAINER).get(0);
        new MutationObserver(() => {
            if (payPalButtonsContainer.hasChildNodes()) {
                $(PAYPAL_CONSTANTS.MARK_PAYPAL_RADIO).closest("label").removeAttr("hidden");
            }
        }).observe(payPalButtonsContainer, {childList: true, subtree: true});
    },

    filterCardFunding: function (funding) {
      if (isChangePaymentButtonEnabled) {
        return funding !== PAYPAL_CONSTANTS.FUNDINGS.CARD;
      }
      return true;
    }
}
