ACC.connectWithPaypal = {

    _autoload: [
        ["renderVaultButtonForConnect", $('#paypalConnectAddPaymentBtn').length !== 0]
    ],

    renderVaultButtonForConnect: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise;

        var createVaultSetupTokenResponse;
        paypal.Buttons({
            fundingSource: 'paypal',

            createVaultSetupToken: async () => {
                const result = await fetch(ACC.config.encodedContextPath + "/paypal/vault/connect/setup-token?CSRFToken=" + ACC.config.CSRFToken, {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json; charset=utf-8"
                    },
                    body: JSON.stringify("login")
                })

                const response = await result.json();
                createVaultSetupTokenResponse = response;
                return response.id
            },

            onApprove: async ({vaultSetupToken}) => {
                let submitForm = $('#' + "savePaymentInfo");

                document.getElementById('setupToken').value = createVaultSetupTokenResponse.id
                document.getElementById('paymentInfoPK').value = createVaultSetupTokenResponse.paymentInfoPK
                document.getElementById('customerId').value = createVaultSetupTokenResponse.customerId

                submitForm.submit();
            },

            onCancel: function (data) {
                fetch(ACC.config.encodedContextPath + "/paypal/vault/payment-info?CSRFToken=" + ACC.config.CSRFToken, {
                    method: "DELETE",
                    headers: {
                        "Content-Type": "application/json; charset=utf-8"
                    },
                    body: createVaultSetupTokenResponse.paymentInfoPK
                })
            },

            onError: function (err) {
                console.log(err);
                ACC.paypalutil.handlePayPalClientError(PAYPAL_CONSTANTS.ERRORS.PAYPAL_CONNECT_SAVED_PAYMENT_METHOD);
            }
        }).render("#paypalConnectAddPaymentBtn");
    },

    createHiddenParameter: function (name, value) {
        return $("<input>").attr("type", "hidden").attr("name", name).val(value);
    }

}
