ACC.applepaycheckout = {

  applepay: undefined,
  globalApplePayConfig: undefined,
  currentAppSession: undefined,
  isAddressChanged: false,

  _autoload: [
    ["renderMarkApplePayButton", $("#applepay-mark-checkout-render-btn-container").length !== 0],
    ["renderCartApplePayButton", $("#applepay-express-checkout-render-btn-container").length !== 0],
  ],

  renderMarkApplePayButton: function() {
    ACC.applepaycheckout.renderApplePayButton();
  },

  renderCartApplePayButton: function() {
    ACC.applepaycheckout.renderApplePayButton("express-checkout");
  },

  checkApplePay: new Promise((resolve, reject) => {
    let errorMessage = "";

    if (!window.ApplePaySession) {
      errorMessage = "This device does not support Apple Pay";
    } else
      if (!ApplePaySession.canMakePayments()) {
        errorMessage = "This device, although an Apple device, is not capable of making Apple Pay payments";
      }
    if (errorMessage !== "") {
      reject(errorMessage);
    } else {
      resolve();
    }
  }),

  renderApplePayButton: async function (callPlace = 'mark-checkout') {
    await ACC.paypalSDKloader.paypalSDKPromise;
    await ACC.applepaySDKloader.applePaySDKPromise;

    ACC.applepaycheckout.checkApplePay
      .then(() => {
        ACC.applepaycheckout.applepay = paypal.Applepay();
        ACC.applepaycheckout.applepay.config()
          .then(applepayConfig => {
            if (applepayConfig.isEligible) {
              ACC.applepaycheckout.globalApplePayConfig = applepayConfig;
              ACC.applepaycheckout.renderButton(ACC.applepaycheckout.getApplePayContainerId(callPlace), ACC.applepaycheckout.getApplePayButtonId(callPlace), ACC.applepaycheckout.resolveButtonStyle(callPlace));
            }
          })
          .catch(error => {
            console.error('Error while fetching Apple Pay configuration:');
            console.error(error);
          });
      })
      .catch((error) => {
        $(PAYPAL_CONSTANTS.APPLE_PAY_LABEL_CONTAINER).hide();
        console.error(error);
      });
  },

  createApplePaySession: function () {
    ACC.applepaycheckout.disableApplePayButtons(true);
    const rawDefaultApplePayShippingAddress = ACC.addons.paypalb2baddon.defaultApplePayShippingAddress;
    const rawChosenApplePayShippingAddress = ACC.addons.paypalb2baddon.chosenApplePayShippingAddress;
    const flow = ACC.applepaycheckout.getFlow();

    $.get(PAYPAL_CONSTANTS.GET_APPLE_PAY_LINE_ITEMS_URL)
      .then((lineItems) => {
        const paymentRequest = {
          countryCode: ACC.applepaycheckout.globalApplePayConfig.countryCode,
          merchantCapabilities: ACC.applepaycheckout.globalApplePayConfig.merchantCapabilities,
          supportedNetworks: ACC.applepaycheckout.globalApplePayConfig.supportedNetworks,
          currencyCode: ACC.addons.paypalb2baddon.currency,
          requiredShippingContactFields: ["name", "email", "postalAddress"],
          requiredBillingContactFields: ["postalAddress"],
          total: lineItems.shift(),
          lineItems: lineItems
        };

        if (flow === PAYPAL_CONSTANTS.FLOWS.EXPRESS_CHECKOUT && rawDefaultApplePayShippingAddress) {
           paymentRequest.shippingContact = JSON.parse(rawDefaultApplePayShippingAddress);
        } else if (flow === PAYPAL_CONSTANTS.FLOWS.MARK_CHECKOUT && rawChosenApplePayShippingAddress) {
           paymentRequest.shippingContact = JSON.parse(rawChosenApplePayShippingAddress);
        }

        ACC.applepaycheckout.currentAppSession = new ApplePaySession(4, paymentRequest);
        ACC.applepaycheckout.currentAppSession.onvalidatemerchant = (event) => ACC.applepaycheckout.onValidateMerchant(event);
        ACC.applepaycheckout.currentAppSession.onpaymentauthorized = (event) => ACC.applepaycheckout.onPaymentAuthorized(event);
        ACC.applepaycheckout.currentAppSession.onshippingcontactselected = (event) => ACC.applepaycheckout.onShippingContactSelected(event);
        ACC.applepaycheckout.currentAppSession.oncancel = () => ACC.applepaycheckout.onCancel(paymentRequest.shippingContact);

        ACC.applepaycheckout.currentAppSession.begin();
      })
      .catch((error) => {
        console.error("Error occurred while fetching ApplePay lineItems", error);
        ACC.applepaycheckout.disableApplePayButtons(false);
      });
  },

  onValidateMerchant: function (event) {
    ACC.applepaycheckout.applepay.validateMerchant({
      validationUrl: event.validationURL,
      displayName: "Powertools"
    })
      .then(validateResult => {
        ACC.applepaycheckout.currentAppSession.completeMerchantValidation(validateResult.merchantSession);
      })
      .catch(validateError => {
        console.error(validateError);
        ACC.applepaycheckout.currentAppSession.abort();
        ACC.applepaycheckout.disableApplePayButtons(false);
      });
  },

  onPaymentAuthorized: function (event) {
    const applePayPayment = event.payment;
    const funding = "applepay";
    const flow = ACC.applepaycheckout.getFlow();
    let applePayEmail = applePayPayment.shippingContact.emailAddress;
    let requestData = JSON.stringify(
      {
        "funding": funding,
        "flow": flow,
        "applePayShippingAddress": applePayPayment.shippingContact
      });
    const createOrderRequest = {
      url: PAYPAL_CONSTANTS.CREATE_ORDER_URL, data: requestData,
      contentType: "application/json; charset=utf-8"
    }

    $.post(createOrderRequest)
      .then((payPalOrderId) => {
        ACC.applepaycheckout.applepay.confirmOrder({
          orderId: payPalOrderId,
          token: applePayPayment.token,
          billingContact: applePayPayment.billingContact
        })
          .then(confirmResult => {
            console.log(confirmResult);
            ACC.applepaycheckout.currentAppSession.completePayment(ApplePaySession.STATUS_SUCCESS);
            const requestDataForMarkProcess = JSON.stringify(
              {
                "flow": flow,
                "funding": funding,
                "email": applePayEmail,
                "applePayBillingAddress": applePayPayment.billingContact
              });
            const responseRequest = {
              url: PAYPAL_CONSTANTS.MARK_PROCESS_URL, data: requestDataForMarkProcess,
              contentType: "application/json; charset=utf-8"
            }
            $.post(responseRequest)
              .then(function (res) {
                const url = PAYPAL_CONSTANTS.CONTEXT_PATH + res;
                window.location.replace(url);
              })
              .catch(function (err) {
                console.log(err);
                ACC.applepaycheckout.disableApplePayButtons(false);
              });
          })
          .catch(confirmError => {
            if (confirmError) {
              console.error('Error confirming order with applepay token');
              console.error(confirmError);
              ACC.applepaycheckout.currentAppSession.completePayment(ApplePaySession.STATUS_FAILURE);
              ACC.applepaycheckout.disableApplePayButtons(false);
            }
          })
      })
      .catch(createError => {
          if (createError) {
            console.error('Error creating order with applepay token');
            ACC.applepaycheckout.disableApplePayButtons(false);
            if (createError.responseJSON === "STATUS_INVALID_SHIPPING_POSTAL_ADDRESS") {
              ACC.applepaycheckout.currentAppSession.completePayment(ApplePaySession.STATUS_INVALID_SHIPPING_POSTAL_ADDRESS);
            } else {
              ACC.applepaycheckout.currentAppSession.completePayment(ApplePaySession.STATUS_FAILURE);
            }
          }
      });
  },

  onShippingContactSelected: function(event) {
    ACC.applepaycheckout.updateShippingAddress(event.shippingContact)
      .done(function (lineItems) {
        ACC.applepaycheckout.isAddressChanged = true;
        ACC.applepaycheckout.currentAppSession.completeShippingContactSelection(
          {
            newTotal: lineItems.shift(),
            newLineItems: lineItems,
            errors: []
          }
        );
      })
      .fail(function (xhr) {
        const error = xhr.responseJSON;
        if (error && error.contactField) {
          const zipAppleError = new ApplePayError(error.code, error.contactField, error.message);
          ACC.applepaycheckout.currentAppSession.completeShippingContactSelection(
            {
              newTotal: { label: "Error", amount: "1", type: "pending" },
              newLineItems: [],
              errors: [zipAppleError],
            }
          );
        } else {
          ACC.applepaycheckout.currentAppSession.abort();
          window.location.href = PAYPAL_CONSTANTS.CHECKOUT_SHIPPING_ADRRESS_STEP_INVALID;
        }
      })
  },

  onCancel: function(initialShippingAddress) {
    ACC.applepaycheckout.disableApplePayButtons(false);

    if (ACC.applepaycheckout.isAddressChanged && initialShippingAddress) {
      ACC.applepaycheckout.updateShippingAddress(initialShippingAddress)
        .done(function () {
          ACC.applepaycheckout.isAddressChanged = false;
        });
    }
  },

  updateShippingAddress: function (shippingContact) {
    if (shippingContact) {
      const request = {
        url: PAYPAL_CONSTANTS.UPDATE_APPLE_PAY_SHIPPING_ADDRESS_URL,
        contentType: "application/json; charset=utf-8",
        data: JSON.stringify(shippingContact),
        redirect: 'follow'
      };
      return $.post(request);
    }
  },

  disableApplePayButtons: function (disable) {
    const applePayButtons = document.getElementsByClassName('apple-pay-button')

    Array.prototype.forEach.call(applePayButtons, applePayButton => {
      if (applePayButton) {
        disable ? applePayButton.classList.add('disabled-apple-pay-button') : applePayButton.classList.remove('disabled-apple-pay-button');
      }
    });
  },

  getApplePayContainerId: function (callPlace) {
     return `applepay-${callPlace}-render-btn-container`;
  },

  getApplePayButtonId: function (callPlace) {
    return `applepay-${callPlace}-button`;
  },

  resolveButtonStyle: function (callPlace) {
    if (callPlace === 'mark-checkout') {
      return applePayButtonConfigMark;
    } else if (callPlace === 'express-checkout') {
      return applePayButtonConfigCart;
    } else {
      return applePayButtonConfigMiniCart;
    }
  },

  renderButton: function (containerId, buttonId, buttonStyle) {
    if (containerId) {
      document.getElementById(containerId).innerHTML = `<apple-pay-button class="apple-pay-button" id="${buttonId}" buttonstyle="${buttonStyle.buttonstyle}" type="${buttonStyle.type}" locale="${ACC.addons.paypalb2baddon.locale}">`;
      document.getElementById(buttonId).addEventListener("click", () => ACC.applepaycheckout.createApplePaySession());
    }
  },


  getFlow: function () {
    return ACC.addons.paypalb2baddon.page === "silentOrderPostPage" ? PAYPAL_CONSTANTS.FLOWS.MARK_CHECKOUT : PAYPAL_CONSTANTS.FLOWS.EXPRESS_CHECKOUT;
  },
}
