<%@ page trimDirectiveWhitespaces="true" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="address" tagdir="/WEB-INF/tags/responsive/address"%>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>

<spring:url value="/" var="homeUrl"/>

<c:set var="showHostedFields" value="${payPalPluginConfiguration.hostedFieldsConfigurationData.vaultFlow eq true && payPalPluginConfiguration.hostedFieldsConfigurationData.enable eq true}" />
<c:set var="showPayPal" value="${payPalPluginConfiguration.payPalConfigurationData.vaultEnabled && payPalPluginConfiguration.payPalConfigurationData.payPalEnable}"/>

<spring:theme code="text.account.credit.card.amount.limited" var="creditCardLimitedMessage"/>
<spring:theme code="text.account.paypal.account.amount.limited" var="payPalLimitedMessage"/>

<div id="globalMessages"></div>
<div class="container">
    <div class="save-payment-method-text">
        <spring:theme code="text.account.profile.paymentMethod.add"/>
    </div>

    <c:if test="${showPayPal}">
        <div class="payment-option-block">
            <label>
                <input id="paypalCheckbox" ${isSavedPayPalAccountsAmountLimited ? 'disabled' : 'checked'} type="radio" name="payment-option" value="paypal">
                <label ${isSavedPayPalAccountsAmountLimited ? 'disabled' : ''}> PayPal </label>
                <c:if test="${isSavedPayPalAccountsAmountLimited}">
                    <p class="limitMessage">${payPalLimitedMessage}</p>
                </c:if>
                <c:if test="${not isSavedPayPalAccountsAmountLimited}">
                    <div id="payment-method-button-container" class="add-payment-method-button">
                        <form:form id="savePaymentInfo" method="POST" action="${request.contextPath}/my-account/add-paypal-payment-method">
                        </form:form>
                    </div>
                </c:if>
            </label>
        </div>
    </c:if>

    <c:if test="${showHostedFields}">
        <div id="hosted-fields-my-account">
            <div class="payment-option-block">
                <label>
                    <input ${isSavedCreditCardsAmountLimited ? 'disabled' : ''} id="cardCheckbox" type="radio" name="payment-option" value="card">
                    <label> Credit Card </label>
                    <c:if test="${isSavedCreditCardsAmountLimited}">
                        <p class="limitMessage">${creditCardLimitedMessage}</p>
                    </c:if>
                </label>
            </div>

            <div id="card-button-container">
            <c:if test="${not isSavedCreditCardsAmountLimited}">
            <form:form action="${request.contextPath}/my-account/add-payment-method" method="post" id="save_credit_card" modelAttribute="addressForm">
                <div class="form-group">
                    <formElement:formInputBox idKey="address.nameOnCard" labelKey="credit.card.name.label" placeholder="credit.card.name.placeholder" path="nameOnCard" inputCSS="form-control" mandatory="true" maxlength="24"/>
                 </div>
                 <div class="form-group">
                    <formElement:formInputBox idKey="address.cardNumber" labelKey="credit.card.number.label" placeholder="credit.card.number.placeholder" path="cardNumber" inputCSS="form-control" mandatory="true" maxlength="19"/>
                 </div>
                <div class="form-group">
                   <formElement:formSelectBox idKey="address.expiryMonth"
                      labelKey="credit.card.expiration.month.label" path="expiryMonth" mandatory="true"
                      skipBlank="false" skipBlankMessageKey="credit.card.expiration.month.placeholder"
                      items="${months}" itemLabel="key" itemValue="value"
                      selectCSSClass="form-control custom-select-form-control" />
                </div>
                <div class="form-group">
                   <formElement:formSelectBox idKey="address.expiryYear"
                      labelKey="credit.card.expiration.year.label" path="expiryYear" mandatory="true"
                      skipBlank="false" skipBlankMessageKey="credit.card.expiration.year.placeholder"
                      items="${years}" itemLabel="key" itemValue="value"
                      selectCSSClass="form-control custom-select-form-control" />
                </div>
                <div class="form-group">
                    <formElement:formInputBox idKey="address.cvv" labelKey="credit.card.cvv.label" path="cvv" placeholder="credit.card.cvv.placeholder" inputCSS="form-control" mandatory="true" maxlength="4"/>
                 </div>
                 </br>
                 <div id="selected-address">
                 </div>

                    <div class="form-group">
                        <div class="form-group">
                            <div class="control">
                                <select id="billingAddressSelector" name="selected-address"
                                        class="form-control custom-select-form-control">
                                    <option value="noAddress">Select billing address</option>
                                    <c:forEach var="address" items="${deliveryAddresses}">
                                        <c:choose>
                                            <c:when test="${addressForm.selectedAddressCode eq address.id}">
                                                <option value="${address.id}" selected>${address.formattedAddress}</option>
                                            </c:when>
                                            <c:otherwise>
                                                <option value="${address.id}">${address.formattedAddress}</option>
                                            </c:otherwise>
                                        </c:choose>
                                    </c:forEach>
                                    <c:choose>
                                        <c:when test="${empty addressForm.selectedAddressCode && not empty accErrorMsgs}">
                                            <option value="newAddress" selected>Add new address</option>
                                        </c:when>
                                        <c:otherwise>
                                            <option value="newAddress">Add new address</option>
                                        </c:otherwise>
                                    </c:choose>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div id="country-selector-form">
                        <div id="countrySelector" class="form-group">
                            <formElement:formSelectBox idKey="address.country"
                                labelKey="address.country" path="countryIso" mandatory="true"
                                skipBlank="false" skipBlankMessageKey="address.country"
                                items="${supportedCountries}" itemValue="isocode"
                                selectedValue="${addressForm.countryIso}"
                                selectCSSClass="form-control" />
                        </div>
                        <div id="i18nAddressForm" class="i18nAddressForm">
                            <c:if test="${not empty country}">
                                <address:addressFormElements regions="${regions}"
                                    country="${country}" />
                            </c:if>
                        </div>
                        <formElement:formCheckbox idKey="address.addBillingAddressToAddressBook"
                            labelKey="credit.card.add.billing.address.to.addressBook"
                            path="addBillingAddressToAddressBook"
                            inputCSS="add-address-left-input"
                            labelCSS="add-address-left-label"
                            />
                    </div>
                </form:form>
                <button type="submit" id="save-credit-card-btn"><spring:theme code="paymentMethod.add.save"/></button>
                </c:if>
            </div>
        </div>
    </c:if>
</div>

    <script>
        let isVaultEnabled = "${payPalPluginConfiguration.payPalConfigurationData.vaultEnabled}";
        let isValidationError = "${not empty accErrorMsgs}";
        let showHostedFields = "${showHostedFields}";
    </script>

