<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:if test="${isPayPalConnectEnabled}">
    <div class="iframe-paypal-connect">
        <span class="paypalConnectButton">
            <div class="paypal-connect-button-container">
                <iframe
                        srcdoc="
                    <html>
                        <body>
                            <div class='paypal-connect-button' style='text-align:center'>
                                <span id='${containerID}'></span>
                            </div>

                            <script>

                                window.open = function (a, b, c, d) {
                                    window.parent.location = a;
                                };

                                importPayPalSdk();
                                function importPayPalSdk() {
                                    var body = document.body;
                                    var script = document.createElement('script');
                                    script.innerHTML = '';
                                    script.setAttribute('data-partner-attribution-id', '${payPalEssentialConfiguration.payPalPartnerAttributionId}');
                                    script.src = '${payPalConnectScript}';
                                    script.async = false;
                                    script.defer = true;
                                    script.onload = function() {
                                        renderButton();
                                    };
                                    body.appendChild(script);
                                }

                                function renderButton() {
                                    var authend = '';
                                    if ('${environmentType}' === 'sandbox') {
                                      authend = 'sandbox';
                                    }
                                    paypal.use(['login'], function (login) {
                                      login.render({
                                        'appid': '${payPalEssentialConfiguration.clientId}',
                                        'authend': authend,
                                        'scopes': '${payPalConnectScopes}',
                                        'containerid': '${containerID}',
                                        'responseType': '${payPalConnectResponseType}',
                                        'theme': '${theme}',
                                        'buttonType': '${buttonType}',
                                        'buttonShape': '${buttonShape}',
                                        'buttonSize': '${buttonSize}',
                                        'fullPage': '${fullPage}',
                                        'returnurl': '${payPalConnectReturnUrl}',
                                        'nonce': '12312312',
                                        'prompt': 'login'
                                      });
                                    });
                                }

                            </script>
                        </body>
                    </html>
                " title="PayPal button component iframe">
                </iframe>
            </div>
        </span>
    </div>
</c:if>