<%@ attribute name="cartData" required="true" type="de.hybris.platform.commercefacades.order.data.CartData" %>
<%@ attribute name="paymentInfo" required="true" type="de.hybris.platform.commercefacades.order.data.CCPaymentInfoData" %>
<%@ attribute name="showPaymentInfo" required="false" type="java.lang.Boolean" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="format" tagdir="/WEB-INF/tags/shared/format" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="ycommerce" uri="http://hybris.com/tld/ycommercetags" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="fragments" tagdir="/WEB-INF/tags/addons/paypalb2baddon/responsive/paymentDetails"%>

<c:if test="${not empty paymentInfo && showPaymentInfo}">
    <ul class="checkout-order-summary-list">
        <li class="checkout-order-summary-list-heading">
            <div class="title">
                <spring:theme
                        code="checkout.summary.paymentMethod.securityCode.whatIsThis.description"
                        var="securityWhatText" />
            </div>
            <div class="title"><spring:theme code="checkout.multi.payment" text="Payment:"></spring:theme></div>
            <div class="address">
                <c:choose>
                    <c:when test="${paymentInfo.cardType eq 'paypal'}">
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                        <c class="pp-account-email">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'applepay'}">
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}" imgClass="paypal-filter-brightness-6"/>
                        <spring:theme code="paymentMethod.applepay"/>
                        <br/>
                        <c class="pp-account-email">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'paypal_credit'}">
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                        <c class="pp-account-email credit">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'venmo'}">
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                        <c class="venmo-account-email">${fn:escapeXml(paymentInfo.payerEmail)}</c>
                    </c:when>
                    <c:when test="${paymentInfo.cardType eq 'card'}">
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                        <c class="pp-account-email-card"><spring:theme code="paymentMethod.credit-debit"/>,
                                ${fn:escapeXml(paymentInfo.accountHolderName)},
                                ${fn:escapeXml(paymentInfo.payerEmail)} </c>
                    </c:when>
                    <c:otherwise>
                        <c:if test="${ (not empty paymentInfo.accountHolderName) and (paymentInfo.accountHolderName ne ' ') }">
                            ${fn:escapeXml(paymentInfo.accountHolderName)}
                        </c:if>
                        <br>
                        <fragments:paymentInfoIcon paymentInfoType="${paymentInfo.cardType}"/>
                        ${fn:escapeXml(paymentInfo.cardTypeData.name)}
                        <br>
                        ${fn:escapeXml(paymentInfo.cardNumber)}
                        <c:if test="${(paymentInfo.expiryMonth ne '0') and (paymentInfo.expiryYear ne '0')}">
                            <br>Expires: ${paymentInfo.expiryMonth}/${paymentInfo.expiryYear}
                        </c:if>
                    </c:otherwise>
                </c:choose>
            </div>
        </li>
    </ul>
</c:if>

