package com.paypal.hybris.b2baddon.validators;

import com.paypal.hybris.addon.forms.CreditCardAddressForm;
import com.paypal.hybris.core.util.ExpiredDateValidatorUtil;
import org.apache.commons.lang.math.NumberUtils;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.validation.Errors;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;
import static org.mockito.Mockito.when;

public class PaypalExpiredDateValidatorTest {

    private static final String EXPIRY_YEAR = "expiryYear";
    private static final String EXPIRY_MONTH = "expiryMonth";
    private static final String CREDIT_CARD_EXPIRY_MONTH_INVALID = "credit.card.expiry.month.invalid";
    private static final String CREDIT_CARD_EXPIRY_YEAR_INVALID = "credit.card.expiry.year.invalid";

    @InjectMocks
    private PaypalExpiredDateValidator unit;
    @Mock
    private ExpiredDateValidatorUtil expiredDateValidatorUtil;
    @Mock
    private Errors errors;
    private CreditCardAddressForm creditCardAddressForm;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        creditCardAddressForm = new CreditCardAddressForm();
    }

    @Test
    public void shouldValidateNotExpiredCreditCard() {
        when(expiredDateValidatorUtil.getMonthsToExpiration(null, null)).thenReturn(NumberUtils.LONG_ZERO);

        unit.validate(creditCardAddressForm, errors);

        verifyNoInteractions(errors);
    }

    @Test
    public void shouldValidateExpiredCreditCard() {
        when(expiredDateValidatorUtil.getMonthsToExpiration(null, null)).thenReturn(NumberUtils.LONG_MINUS_ONE);

        unit.validate(creditCardAddressForm, errors);

        verify(errors).rejectValue(EXPIRY_MONTH, CREDIT_CARD_EXPIRY_MONTH_INVALID);
        verify(errors).rejectValue(EXPIRY_YEAR, CREDIT_CARD_EXPIRY_YEAR_INVALID);
    }

    @Test
    public void shouldSupportCreditCardAddressForm() {
        assertTrue(unit.supports(CreditCardAddressForm.class));
    }

}
