package com.paypal.hybris.b2baddon.validators;

import de.hybris.platform.acceleratorstorefrontcommons.forms.UpdatePasswordForm;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.validation.Errors;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;

public class PayPalPasswordValidatorTest {


    private static final String INVALID_PASSWORD = "updatePwd.pwd.invalid";
    private static final String NEW_PASSWORD = "newPassword";
    private static final String CHECK_NEW_PASSWORD = "checkNewPassword";
    private static final String PASSWORD = "qwerty";
    private static final String TOO_LONG_PASSWORD = new String(new byte[256]);
    private static final String TOO_SHORT_PASSWORD = new String(new byte[5]);
    @InjectMocks
    private PayPalPasswordValidator unit;
    @Mock
    private Errors errors;
    private UpdatePasswordForm passwordForm;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        passwordForm = new UpdatePasswordForm();
    }

    @Test
    public void shouldValidateValidPassword() {
        passwordForm.setNewPassword(PASSWORD);
        passwordForm.setCheckNewPassword(PASSWORD);

        unit.validate(passwordForm, errors);

        verifyNoInteractions(errors);
    }

    @Test
    public void shouldValidateEmptyPassword() {
        unit.validate(passwordForm, errors);

        verify(errors).rejectValue(NEW_PASSWORD, INVALID_PASSWORD);
        verify(errors).rejectValue(CHECK_NEW_PASSWORD, INVALID_PASSWORD);
    }

    @Test
    public void shouldValidateTooLongPassword() {
        passwordForm.setNewPassword(TOO_LONG_PASSWORD);
        passwordForm.setCheckNewPassword(TOO_LONG_PASSWORD);

        unit.validate(passwordForm, errors);

        verify(errors).rejectValue(NEW_PASSWORD, INVALID_PASSWORD);
        verify(errors).rejectValue(CHECK_NEW_PASSWORD, INVALID_PASSWORD);
    }

    @Test
    public void shouldValidateTooShortPassword() {
        passwordForm.setNewPassword(TOO_SHORT_PASSWORD);
        passwordForm.setCheckNewPassword(TOO_SHORT_PASSWORD);

        unit.validate(passwordForm, errors);

        verify(errors).rejectValue(NEW_PASSWORD, INVALID_PASSWORD);
        verify(errors).rejectValue(CHECK_NEW_PASSWORD, INVALID_PASSWORD);
    }

    @Test
    public void shouldSupportUpdatePasswordForm() {
        assertTrue(unit.supports(UpdatePasswordForm.class));
    }

}
