package com.paypal.hybris.b2baddon.security.impl;

import com.paypal.hybris.b2baddon.security.ConnectWithPayPalAuthenticationToken;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorstorefrontcommons.security.GUIDCookieStrategy;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.RememberMeServices;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class DefaultPayPalAutoLoginStrategyTest {

    private static final String USER_NAME = "userName";
    @InjectMocks
    private DefaultPayPalAutoLoginStrategy unit;
    @Mock
    private AuthenticationManager authenticationManager;
    @Mock
    private CustomerFacade customerFacade;
    @Mock
    private GUIDCookieStrategy guidCookieStrategy;
    @Mock
    private RememberMeServices rememberMeServices;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private ConnectWithPayPalAuthenticationToken authenticationToken;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldLogin() {
        when(authenticationManager.authenticate(any(ConnectWithPayPalAuthenticationToken.class)))
                .thenReturn(authenticationToken);
        unit.login(USER_NAME, request, response);

        verify(authenticationManager).authenticate(any(ConnectWithPayPalAuthenticationToken.class));
        assertNotNull(SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void shouldNotLoginWhenAuthenticationExceptionOccurs() {
        when(authenticationManager.authenticate(any(ConnectWithPayPalAuthenticationToken.class)))
                .thenThrow(BadCredentialsException.class);

        unit.login(USER_NAME, request, response);

        verify(authenticationManager).authenticate(any(ConnectWithPayPalAuthenticationToken.class));
        assertNull(SecurityContextHolder.getContext().getAuthentication());
    }

}
