package com.paypal.hybris.b2baddon.security.handler;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.cms2.model.site.CMSSiteModel;
import de.hybris.platform.cms2.servicelayer.services.CMSSiteService;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PasswordVerificationSuccessHandlerTest {

    @InjectMocks
    private PasswordVerificationSuccessHandler unit;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private RedirectStrategy redirectStrategy;
    @Mock
    private CMSSiteService cmsSiteService;
    @Mock
    private CMSSiteModel cmsSiteModel;
    @Mock
    private Authentication authentication;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        when(cmsSiteService.getCurrentSite()).thenReturn(cmsSiteModel);

    }

    @Test
    public void shouldRedirectToConnectLoginPageWhenRequiresAuthentication() throws IOException {
        when(cmsSiteModel.isRequiresAuthentication()).thenReturn(Boolean.TRUE);

        unit.onAuthenticationSuccess(request, response, authentication);

        verify(redirectStrategy).sendRedirect(request, response, CONNECT_LOGIN_ACCOUNT_CONNECT);
    }

    @Test
    public void shouldRedirectToConnectNoAuthenticationPageWhenDoesNotRequiresAuthentication() throws IOException {
        when(cmsSiteModel.isRequiresAuthentication()).thenReturn(Boolean.FALSE);

        unit.onAuthenticationSuccess(request, response, authentication);

        verify(redirectStrategy).sendRedirect(request, response, CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT);
    }

}
