package com.paypal.hybris.b2baddon.security.handler;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorstorefrontcommons.security.BruteForceAttackCounter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import java.io.IOException;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PasswordVerificationFailureHandlerTest {

    private static final String USERNAME = "userName";
    @InjectMocks
    private PasswordVerificationFailureHandler unit;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private HttpSession session;
    @Mock
    private BruteForceAttackCounter bruteForceAttackCounter;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        when(request.getSession()).thenReturn(session);
        when(request.getParameter(PasswordVerificationFailureHandler.J_USERNAME_PARAM)).thenReturn(USERNAME);
    }

    @Test
    public void shouldRegisterLoginFailureAndSetLastUsernameParamToSession() throws ServletException, IOException {
        unit.onAuthenticationFailure(request, response, new BadCredentialsException(USERNAME));

        verify(bruteForceAttackCounter).registerLoginFailure(USERNAME);
        verify(session).setAttribute(PasswordVerificationFailureHandler.SPRING_SECURITY_LAST_USERNAME, USERNAME);
    }

}
