package com.paypal.hybris.b2baddon.forms.validation;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.b2bacceleratoraddon.forms.RegistrationForm;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.validation.Errors;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;

@UnitTest
public class PayPalConnectRegistrationValidatorTest {

    private static final String STREET = "companyAddressStreet";
    private static final String CITY = "companyAddressCity";
    private static final String COMPANY_NAME = "companyName";
    private static final String COUNTRY_ISO = "companyAddressCountryIso";
    private static final String POSITION = "position";
    private static final String POSTAL_CODE = "companyAddressPostalCode";
    private static final String PHONE = "telephone";
    private static final String TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY = "text.secureportal.register.field.mandatory";

    @InjectMocks
    private PayPalConnectRegistrationValidator unit;

    @Mock
    private Errors errors;
    private RegistrationForm registrationForm;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
        registrationForm = new RegistrationForm();
    }

    @Test
    public void shouldValidateValidRegistrationForm() {
        registrationForm.setCompanyAddressStreet(STREET);
        registrationForm.setCompanyAddressCity(CITY);
        registrationForm.setCompanyName(COMPANY_NAME);
        registrationForm.setCompanyAddressCountryIso(COUNTRY_ISO);
        registrationForm.setPosition(POSITION);
        registrationForm.setCompanyAddressPostalCode(POSTAL_CODE);
        registrationForm.setTelephone(PHONE);

        unit.validate(registrationForm, errors);

        verifyNoInteractions(errors);
    }

    @Test
    public void shouldValidateInvalidRegistrationForm() {
        unit.validate(registrationForm, errors);

        verify(errors).rejectValue(STREET, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(CITY, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(COMPANY_NAME, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(COUNTRY_ISO, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(POSITION, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(POSTAL_CODE, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
        verify(errors).rejectValue(PHONE, TEXT_SECUREPORTAL_REGISTER_FIELD_MANDATORY);
    }

    @Test
    public void shouldSupportRegistrationFormObject() {
        assertTrue(unit.supports(RegistrationForm.class));
    }

    @Test
    public void shouldNotSupportNonRegistrationFormObject() {
        assertFalse(unit.supports(Object.class));
    }
}
