/*

 */
package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants;
import com.paypal.hybris.b2baddon.security.PayPalAutoLoginStrategy;
import com.paypal.hybris.b2bfacade.PayPalB2BRegistrationUserFacade;
import com.paypal.hybris.core.enums.ExpirationStatus;
import com.paypal.hybris.core.exception.PayPalConnectException;
import com.paypal.hybris.core.exception.PayPalUnverifiedAccountException;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.data.*;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalCreditCardFacade;
import com.paypal.hybris.facade.facades.PayPalCustomerFacade;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import com.paypal.hybris.facade.facades.PayPalSetUpPasswordFacade;
import de.hybris.platform.acceleratorstorefrontcommons.breadcrumb.Breadcrumb;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractLoginPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.forms.RegisterForm;
import de.hybris.platform.b2bacceleratoraddon.constants.B2bacceleratoraddonWebConstants;
import de.hybris.platform.b2bacceleratoraddon.forms.RegistrationForm;
import de.hybris.platform.b2bacceleratorfacades.exception.CustomerAlreadyExistsException;
import de.hybris.platform.b2bacceleratorfacades.exception.RegistrationNotEnabledException;
import de.hybris.platform.b2bacceleratorfacades.registration.B2BRegistrationFacade;
import de.hybris.platform.b2bcommercefacades.data.B2BRegistrationData;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.pages.AbstractPageModel;
import de.hybris.platform.cms2.model.pages.ContentPageModel;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.converters.Converters;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.util.localization.Localization;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import com.paypal.hybris.facade.facades.PayPalConnectWithPayPalNotificationFacade;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_CONNECT_AUTHORIZATION_CODE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.HOME_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.Views.PAYPAL_CONNECT_REGISTRATION_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.Views.PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE;
import static com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants.Views.Pages.Login.ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
import static de.hybris.platform.util.localization.Localization.getLocalizedString;
import static java.util.Objects.nonNull;

@Controller
@RequestMapping(value = "/paypal/connect")
public class PayPalConnectRegistrationController extends AbstractLoginPageController {

    private static final Logger LOG = Logger.getLogger(PayPalConnectRegistrationController.class);

    private static final String SCP_LINK_CREATE_ACCOUNT = "text.secureportal.link.createAccount";
    private static final String REGISTER_SUBMIT_CONFIRMATION = "paypal.connect.registration.request.created";
    private static final String REGISTER_REQUEST_NOR_APPROVED = "paypal.connect.registration.request.notApproved";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String PAYER_ID = "payerId";
    private static final String ADDRESS_DATA = "addressData";
    private static final String LOGIN_LABEL = "login";
    private static final String BREADCRUBMS = "breadcrumbs";
    private static final String PAYPAL_CONNECT_GLOBAL_ERROR = "paypal.connect.registration.global.error";
    private static final String HOME_REDIRECT = REDIRECT_PREFIX + ROOT;
    private static final String SAVE_PAYMENT_INFO = "savePaymentInfoUrl";
    private static final String SAVE_PAYMENT_INFO_URL = "paypal/connect/savePaymentInfo";
    private static final String SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE = "/paypal/connect/savePaymentInfoAndAddressB2BPage";
    private static final String USER_IS_REGISTERED = "userIsRegistered";
    private static final String LOGIN_PAGE_REDIRECT = REDIRECT_PREFIX + "/login";
    private static final String LOGIN_PAGE = "LOGIN";
    private static final String PAYPAL_CHECKOUT_DATA = "payPalCheckoutData";
    private static final String SHOULD_SAVE_ADDRESS = "shouldSaveAddress";
    private static final String SHOULD_SET_UP_PASSWORD_MESSAGE = "shouldShowSetUpPasswordMessage";
    private static final String SHOULD_SAVE_PAYMENT_INFO = "shouldSavePaymentInfo";
    private static final String IS_USER_APPROVED = "isUserApproved";
    private static final String WAS_USER_REGISTERED = "wasUserRegistered";
    private static final String DID_USER_HAVE_PAYER_ID = "didCustomerHavePayerId";
    private static final String UNVERIFIED_ACCOUNT_ERROR = "paypal.connect.unverified.account.error";
    private static final String PASSWORD_VERIFICATION_ERROR = "paypal.connect.password.verification.error";
    private static final String EMAIL_ATTRIBUTE = "email";
    private static final String USER_DATA_ATTRIBUTE = "userData";
    private static final String BASE_SITE_NAME_ATTRIBUTE = "baseSiteName";
    private static final String VAULT_PROCESS = "vaultProcessUrl";
    private static final String VAULT_PROCESS_URL = "paypal/connect/response";

    @Resource(name = "payPalCustomerFacade")
    private PayPalCustomerFacade payPalCustomerFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "commonI18NService")
    private CommonI18NService commonI18NService;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultConfigurationService;

    @Resource(name = "countryConverter")
    private Converter<CountryModel, CountryData> countryConverter;

    @Resource(name = "paypalConnectRegistrationValidator")
    private Validator registrationValidator;

    @Resource(name = "b2bRegistrationFacade")
    private B2BRegistrationFacade b2bRegistrationFacade;

    @Resource(name = "payPalConnectService")
    private PayPalConnectService payPalConnectService;

    @Resource(name = "payPalRegistrationUserFacade")
    private PayPalRegistrationUserFacade payPalRegistrationUserFacade;

    @Resource(name = "payPalCustomerAccountService")
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Resource(name = "payPalB2BRegistrationUserFacade")
    private PayPalB2BRegistrationUserFacade payPalB2BRegistrationUserFacade;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "payPalCreditCardFacade")
    private PayPalCreditCardFacade payPalCreditCardFacade;

    @Resource(name = "payPalSetUpPasswordFacade")
    private PayPalSetUpPasswordFacade payPalSetUpPasswordFacade;

    @Resource(name = "payPalAutoLoginStrategy")
    private PayPalAutoLoginStrategy payPalAutoLoginStrategy;

    @Resource
    private PayPalConnectWithPayPalNotificationFacade payPalConnectWithPayPalNotificationFacade;

    @GetMapping(value = "/register")
    public String getRegister(final RegisterForm form, final BindingResult bindingResult, final HttpServletRequest request,
                      final HttpServletResponse response, final HttpSession session,
                      final RedirectAttributes redirectAttributes, final Model model) throws CMSItemNotFoundException {
        final String authorizationCode = request.getParameter(PAYPAL_CONNECT_AUTHORIZATION_CODE);
        if (authorizationCode == null) {
            return HOME_REDIRECT;
        }
        String accessToken;
        PayPalConnectUserData userData;
        String email;
        PayPalUserExistB2BData userExistB2BData;
        try {
            if (sessionService.getAttribute(ACCESS_TOKEN) == null) {
                accessToken = payPalConnectService
                        .exchangeAuthorizationCodeToAccessToken(authorizationCode);
            } else {
                accessToken = (String) sessionService.getAttribute(ACCESS_TOKEN);
            }
            userData = payPalConnectService.getUserDataByAccessToken(accessToken);
            email = payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData);
            userExistB2BData = payPalB2BRegistrationUserFacade.isCustomerExistAndApprovedByUID(email);
        } catch (PayPalUnverifiedAccountException e) {
            LOG.error(e.getMessage(), e);
            GlobalMessages.addFlashMessage(redirectAttributes,
                    GlobalMessages.ERROR_MESSAGES_HOLDER,
                    getLocalizedString(UNVERIFIED_ACCOUNT_ERROR));
            return LOGIN_PAGE_REDIRECT;
        }

        if (userExistB2BData.getIsExist() && userExistB2BData.getIsApproved()) {
            return registerApprovedPayPalUser(userData, email, request, response);
        } else if (userExistB2BData.getIsExist()) {
            GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.ERROR_MESSAGES_HOLDER, Localization.getLocalizedString(REGISTER_REQUEST_NOR_APPROVED));
            return LOGIN_PAGE_REDIRECT;
        }

        boolean isShouldAddPaymentMethod = defaultConfigurationService.isPayPalEnable() &&
                defaultConfigurationService.isPayPalVaultEnabled();
        sessionService.setAttribute(ACCESS_TOKEN, accessToken);
        final List<CountryData> countries = Converters
            .convertAll(commonI18NService.getAllCountries(), countryConverter);
        model.addAttribute("titles", userFacade.getTitles());
        model.addAttribute("countries", countries);
        sessionService.setAttribute(IS_USER_APPROVED, false);
        sessionService.setAttribute(SHOULD_SAVE_ADDRESS, true);
        sessionService.setAttribute(SHOULD_SAVE_PAYMENT_INFO, isShouldAddPaymentMethod);
        populateModelCmsContent(model,
            getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
        model.addAttribute(new RegistrationForm());
        return PAYPAL_CONNECT_REGISTRATION_PAGE;
    }

    private String registerApprovedPayPalUser(PayPalConnectUserData userData, String email,
                                              HttpServletRequest request, HttpServletResponse response) {
        if (!payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id())) {
            if(!defaultConfigurationService.isEnableLoginViaPayPalToTheExistingUser()){
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.CONF_MESSAGES_HOLDER,
                        DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE, null);
                return LOGIN_PAGE_REDIRECT;
            }

            sessionService.setAttribute(USER_DATA_ATTRIBUTE, userData);
            sessionService.setAttribute(EMAIL_ATTRIBUTE, email);
            if (defaultConfigurationService.isPayPalAdditionalSecurityEnabled()) {
                return REDIRECT_PREFIX + CONNECT_LOGIN_ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
            } else {
                return REDIRECT_PREFIX + CONNECT_LOGIN_ACCOUNT_CONNECT;
            }
        }
        if (Objects.nonNull(sessionService.getAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE))) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.registration.message.set.up.password.for.new.user", null);
            sessionService.removeAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE);
        }
        return processLogin(request, response, userData.getPayer_id());
    }

    @PostMapping(value = "/register")
    public String doRegister(final RegistrationForm form, final BindingResult bindingResult,
        final HttpServletRequest request,
        final HttpSession session, final Model model, final RedirectAttributes redirectAttributes) throws CMSItemNotFoundException, RegistrationNotEnabledException {
        populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);

        registrationValidator.validate(form, bindingResult);
        if (bindingResult.hasErrors()) {
            final List<CountryData> countries = Converters
                    .convertAll(commonI18NService.getAllCountries(), countryConverter);
            model.addAttribute("titles", userFacade.getTitles());
            model.addAttribute("countries", countries);
            return PAYPAL_CONNECT_REGISTRATION_PAGE;
        }

        final String accessToken = (String) sessionService.getAttribute(ACCESS_TOKEN);
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);

        sessionService.setAttribute(PAYER_ID, userData.getPayer_id());
        sessionService.setAttribute(ADDRESS_DATA, userData.getAddress());
        try {
            b2bRegistrationFacade.register(convertFormAndPayPalDataToRegistrationData(form, userData));
            payPalRegistrationUserFacade
                    .setPayerIdToUser(payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData), userData.getPayer_id());
            payPalSetUpPasswordFacade.setPasswordForSingleAuthenticationActiveToCustomer(
                    payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData), false);
            sessionService.setAttribute(USER_IS_REGISTERED, true);
            sessionService.setAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE, Boolean.TRUE);
            setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(false, false);
        } catch (PayPalUnverifiedAccountException e) {
            LOG.error(e.getMessage(), e);
            GlobalMessages.addFlashMessage(redirectAttributes,
                    GlobalMessages.ERROR_MESSAGES_HOLDER,
                    getLocalizedString(UNVERIFIED_ACCOUNT_ERROR));
            return getDefaultLoginPage(false, session, model);
        } catch (final CustomerAlreadyExistsException e) {
            LOG.error("Failed to register account. Account already exists.", e);
            GlobalMessages.addErrorMessage(model, Localization.getLocalizedString(PAYPAL_CONNECT_GLOBAL_ERROR));
            return getRegistrationView();
        }
        if (defaultConfigurationService.isPayPalConnectAddPaymentMethodFlow()) {
            return REDIRECT_PREFIX + SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE;
        } else {
            populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
            model.addAttribute(form);
            GlobalMessages.addConfMessage(model, Localization.getLocalizedString(REGISTER_SUBMIT_CONFIRMATION));
            session.removeAttribute(ACCESS_TOKEN);
            return getDefaultLoginPage(false, session, model);
        }
    }

    @RequestMapping(value = "/accountConnectPasswordVerificationPage", method = RequestMethod.GET)
    public String getAccountConnectVerificationPage(final Model model, @RequestParam(required = false) final boolean invalidPassword)
            throws CMSItemNotFoundException {
        PayPalConnectUserData userData = sessionService.getAttribute(USER_DATA_ATTRIBUTE);
        if (nonNull(userData) && !payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id())) {
            model.addAttribute(EMAIL_ATTRIBUTE, sessionService.getAttribute(EMAIL_ATTRIBUTE));
            model.addAttribute(BASE_SITE_NAME_ATTRIBUTE, getBaseSiteService().getCurrentBaseSite().getName());
            storeCmsPageInModel(model, getCmsPage());
            setUpMetaDataForContentPage(model, (ContentPageModel) getCmsPage());
            if (invalidPassword) {
                GlobalMessages.addErrorMessage(model, getLocalizedString(PASSWORD_VERIFICATION_ERROR));
            }
            return ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
        }
        return REDIRECT_PREFIX + HOME_PAGE;
    }

    @RequestMapping(value = "/account-connect", method = RequestMethod.GET)
    public String doConnectPayPalAccount(final HttpServletRequest request, final HttpServletResponse response) {
        PayPalConnectUserData userData = sessionService.getAttribute(USER_DATA_ATTRIBUTE);
        String email = sessionService.getAttribute(EMAIL_ATTRIBUTE);
        PayPalUserExistB2BData userExistB2BData = payPalB2BRegistrationUserFacade.isCustomerExistAndApprovedByUID(email);

        payPalRegistrationUserFacade.setPayerIdToUser(email, userData.getPayer_id());
        payPalConnectWithPayPalNotificationFacade.sendLinkCustomerEmailNotification(email);
        if (!defaultConfigurationService.isPayPalConnectAddPaymentMethodFlow()) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            return processLogin(request, response, userData.getPayer_id());
        }
        boolean isPayPalAddressPresent = payPalCustomerFacade.isPayPalAddressPresent(email, userData.getAddress());

        boolean isPayPalPaymentMethodPresent = payPalCustomerFacade.isPayPalPaymentMethodPresent(email, userData);
        if (isPayPalPaymentMethodPresent && isPayPalAddressPresent) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            return processLogin(request, response, userData.getPayer_id());
        }
        sessionService.setAttribute(IS_USER_APPROVED, userExistB2BData.getIsApproved());
        sessionService.setAttribute(SHOULD_SAVE_ADDRESS, !isPayPalAddressPresent);
        sessionService.setAttribute(SHOULD_SAVE_PAYMENT_INFO, !isPayPalPaymentMethodPresent);
        sessionService.setAttribute(PAYER_ID, userData.getPayer_id());
        sessionService.setAttribute(ADDRESS_DATA, userData.getAddress());
        setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(true, false);

        sessionService.removeAttribute(USER_DATA_ATTRIBUTE);
        sessionService.removeAttribute(EMAIL_ATTRIBUTE);
        return REDIRECT_PREFIX + SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE;
    }

    @GetMapping(value = "/savePaymentInfoAndAddressB2BPage")
    public String getSavePaymentInfoAndAddressB2BPage(final Model model, final HttpSession session) throws CMSItemNotFoundException {

        setModelAttributesForPaymentAndAddressInfo(model);

        storeCmsPageInModel(model, getCmsPage());
        setUpMetaDataForContentPage(model, (ContentPageModel) getCmsPage());

        if (sessionService.getAttribute(USER_IS_REGISTERED) != null) {
            GlobalMessages.addConfMessage(model, Localization.getLocalizedString(REGISTER_SUBMIT_CONFIRMATION));
        }
        sessionService.removeAttribute(USER_IS_REGISTERED);

        return PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE;
    }

    @PostMapping(value = "/savePaymentInfo")
    public String doSavePaymentInfo(final RegisterForm form, final BindingResult bindingResult, final HttpServletRequest request,
        final HttpServletResponse response,
        final HttpSession session, final Model model) throws CMSItemNotFoundException {
        populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);
        displayingGlobalMessageToRegisteredAndNotRegisteredUser(request);
        sessionService.removeAttribute(ACCESS_TOKEN);
        sessionService.removeAttribute(SHOULD_SAVE_PAYMENT_INFO);
        sessionService.removeAttribute(SHOULD_SAVE_ADDRESS);
        if((boolean) sessionService.getAttribute(IS_USER_APPROVED)){
            sessionService.removeAttribute(IS_USER_APPROVED);
            return processLogin(request, response, sessionService.getAttribute(PAYER_ID));
        }
        sessionService.removeAttribute(IS_USER_APPROVED);
        return LOGIN_PAGE_REDIRECT;
    }

    @PostMapping(value = "/response")
    public String doHandlePayPalResponse(final PaymentTokenData paymentTokenData, final HttpServletRequest request,
                                         final HttpServletResponse response,
                                         final RedirectAttributes redirectAttributes) {
        final String payerId = sessionService.getAttribute(PAYER_ID);
        final PayPalConnectAddressData addressData = sessionService.getAttribute(ADDRESS_DATA);
        if(sessionService.getAttribute(SHOULD_SAVE_PAYMENT_INFO)) {
            try {
                payPalCreditCardFacade.requestPaymentToken(paymentTokenData);
                GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.saved.payment.method");
            } catch (Exception e) {
                LOG.error("Error during adding payment method for new customer", e);
                GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.saved.payment.method.error");
            }
        }
        if(sessionService.getAttribute(SHOULD_SAVE_ADDRESS)) {
            try {
                if (addressData != null) {
                    acceleratorCheckoutFacade.addAddressForNewUser(addressData, payerId);
                    GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.saved.address");
                }
            } catch (Exception e) {
                LOG.error("Error during adding address for new customer", e);
                GlobalMessages.addFlashMessage(redirectAttributes, GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.saved.address.error");
            }
        }
        displayingGlobalMessageToRegisteredAndNotRegisteredUser(request);
        sessionService.removeAttribute(SHOULD_SAVE_PAYMENT_INFO);
        sessionService.removeAttribute(SHOULD_SAVE_ADDRESS);
        sessionService.removeAttribute(ACCESS_TOKEN);
        sessionService.removeAttribute(ADDRESS_DATA);
        if(sessionService.getAttribute(IS_USER_APPROVED)) {
            sessionService.removeAttribute(IS_USER_APPROVED);
            return processLogin(request, response, sessionService.getAttribute(PAYER_ID));
        }
        sessionService.removeAttribute(IS_USER_APPROVED);
        return LOGIN_PAGE_REDIRECT;
    }

    @ExceptionHandler(PayPalConnectException.class)
    public String handlerPayPalConnectException(HttpServletRequest request, PayPalConnectException e) {
        GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.access.error" , null);
        return LOGIN_PAGE_REDIRECT;
    }

    protected B2BRegistrationData convertFormAndPayPalDataToRegistrationData(
        final RegistrationForm form, PayPalConnectUserData userData) {
        final B2BRegistrationData registrationData = new B2BRegistrationData();
        BeanUtils.copyProperties(form, registrationData);
        registrationData.setName(userData.getName());
        registrationData.setEmail(payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData));
        return registrationData;
    }

    protected void populateModelCmsContent(final Model model, final ContentPageModel contentPageModel) {

        storeCmsPageInModel(model, contentPageModel);
        setUpMetaDataForContentPage(model, contentPageModel);

        final Breadcrumb registrationBreadcrumbEntry = new Breadcrumb("#",
            getMessageSource().getMessage(SCP_LINK_CREATE_ACCOUNT, null, getI18nService().getCurrentLocale()), null);
        model.addAttribute(BREADCRUBMS, Collections.singletonList(registrationBreadcrumbEntry));
    }

    private String processLogin(final HttpServletRequest request, final HttpServletResponse response, final String payerId) {
        final CustomerData customer = payPalCustomerAccountService.getCustomerDataByPayerId(payerId);

        String expiredStatus = payPalCreditCardFacade.getCardsExpirationStatus(customer.getUid());
        if (expiredStatus.equals(ExpirationStatus.EXPIRED.getCode())) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.INFO_MESSAGES_HOLDER, Paypalb2baddonWebConstants.EXPIRED_MESSAGE, null);
        }
        if (expiredStatus.equals(ExpirationStatus.EXPIRE_SOON.getCode())) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.INFO_MESSAGES_HOLDER, Paypalb2baddonWebConstants.EXPIRED_SOON_MESSAGE, null);
        }

        payPalAutoLoginStrategy.login(customer.getUid(), request, response);
        return getSuccessRedirect(request, response);
    }

    @Override
    protected AbstractPageModel getCmsPage() throws CMSItemNotFoundException {
        return getContentPageForLabelOrId(LOGIN_LABEL);
    }

    @Override
    protected String getSuccessRedirect(HttpServletRequest request, HttpServletResponse response) {
        return REDIRECT_PREFIX + ROOT;
    }

    @Override
    protected String getView() {
        return B2bacceleratoraddonWebConstants.Views.LOGIN_PAGE;
    }

    private String getRegistrationView() {
        return B2bacceleratoraddonWebConstants.Views.REGISTRATION_PAGE;
    }

    private void setModelAttributesForPaymentAndAddressInfo(Model model) {
        final PayPalCheckoutData checkoutData = acceleratorCheckoutFacade.getPayPalCheckoutData(LOGIN_PAGE);

        model.addAttribute(VAULT_PROCESS, VAULT_PROCESS_URL);
        model.addAttribute(PAYPAL_CHECKOUT_DATA, checkoutData);
        model.addAttribute(SAVE_PAYMENT_INFO, SAVE_PAYMENT_INFO_URL);
        model.addAttribute(SHOULD_SAVE_ADDRESS, sessionService.getAttribute(SHOULD_SAVE_ADDRESS));
        model.addAttribute(SHOULD_SAVE_PAYMENT_INFO, sessionService.getAttribute(SHOULD_SAVE_PAYMENT_INFO));
    }

    private void setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(boolean wasUserRegistered, boolean didUserHavePayerId) {
        sessionService.setAttribute(WAS_USER_REGISTERED, wasUserRegistered);
        sessionService.setAttribute(DID_USER_HAVE_PAYER_ID, didUserHavePayerId);
    }

    private void displayingGlobalMessageToRegisteredAndNotRegisteredUser(HttpServletRequest request) {
        if (Objects.nonNull(sessionService.getAttribute(WAS_USER_REGISTERED))
                && Objects.nonNull(sessionService.getAttribute(DID_USER_HAVE_PAYER_ID))) {
            boolean wasUserRegistered = sessionService.getAttribute(WAS_USER_REGISTERED);
            boolean didUserHavePayerId = sessionService.getAttribute(DID_USER_HAVE_PAYER_ID);
            if (wasUserRegistered && !didUserHavePayerId) {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            }
        }
        sessionService.removeAttribute(WAS_USER_REGISTERED);
        sessionService.removeAttribute(DID_USER_HAVE_PAYER_ID);
    }
}
