/*

 */
package com.paypal.hybris.b2baddon.controllers.pages;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants;
import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.security.PayPalAutoLoginStrategy;
import com.paypal.hybris.b2bfacade.PayPalB2BRegistrationUserFacade;
import com.paypal.hybris.core.enums.ExpirationStatus;
import com.paypal.hybris.core.exception.PayPalConnectException;
import com.paypal.hybris.core.exception.PayPalUnverifiedAccountException;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.service.PayPalConnectService;
import com.paypal.hybris.core.service.PayPalCustomerAccountService;
import com.paypal.hybris.data.PayPalCheckoutData;
import com.paypal.hybris.data.PayPalConnectAddressData;
import com.paypal.hybris.data.PayPalConnectUserData;
import com.paypal.hybris.data.PayPalUserExistB2BData;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.facade.facades.PayPalConnectWithPayPalNotificationFacade;
import com.paypal.hybris.facade.facades.PayPalCreditCardFacade;
import com.paypal.hybris.facade.facades.PayPalCustomerFacade;
import com.paypal.hybris.facade.facades.PayPalRegistrationUserFacade;
import de.hybris.platform.acceleratorfacades.flow.CheckoutFlowFacade;
import de.hybris.platform.acceleratorstorefrontcommons.breadcrumb.Breadcrumb;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractLoginPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.forms.RegisterForm;
import de.hybris.platform.b2bacceleratoraddon.constants.B2bacceleratoraddonWebConstants;
import de.hybris.platform.b2bacceleratoraddon.forms.RegistrationForm;
import de.hybris.platform.b2bacceleratorfacades.exception.CustomerAlreadyExistsException;
import de.hybris.platform.b2bacceleratorfacades.exception.RegistrationNotEnabledException;
import de.hybris.platform.b2bacceleratorfacades.registration.B2BRegistrationFacade;
import de.hybris.platform.b2bcommercefacades.data.B2BRegistrationData;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.pages.AbstractPageModel;
import de.hybris.platform.cms2.model.pages.ContentPageModel;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.commercefacades.user.data.CountryData;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.converters.Converters;
import de.hybris.platform.core.model.c2l.CountryModel;
import de.hybris.platform.servicelayer.dto.converter.Converter;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.session.SessionService;
import de.hybris.platform.util.localization.Localization;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CMS_REGISTER_PAGE_NAME;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYPAL_CONNECT_AUTHORIZATION_CODE;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.Views;
import static de.hybris.platform.util.localization.Localization.getLocalizedString;

@Controller
@RequestMapping(value = "paypal/connect/noauthentication")
public class PayPalConnectNoAuthenticationController extends AbstractLoginPageController {

    private static final Logger LOG = Logger.getLogger(PayPalConnectNoAuthenticationController.class);

    private static final String SCP_LINK_CREATE_ACCOUNT = "text.secureportal.link.createAccount";
    private static final String REGISTER_SUBMIT_CONFIRMATION = "paypal.connect.registration.request.created";
    private static final String REGISTER_REQUEST_NOR_APPROVED = "paypal.connect.registration.request.notApproved";
    private static final String REDIRECT_TO_CHECKOUT_PAGE = "/paypal/connect/noauthentication/register/checkout";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String PAYER_ID = "payerId";
    private static final String LOGIN_PAGE_REDIRECT = "redirect:/login";
    private static final String PAYPAL_CONNECT_SERVLET_PATH = "/checkout";
    private static final String LOGIN_CHECKOUT_PAGE_REDIRECT = LOGIN_PAGE_REDIRECT + PAYPAL_CONNECT_SERVLET_PATH;
    private static final String ADDRESS_DATA = "addressData";
    private static final String LOGIN_LABEL = "login";
    private static final String CHECKOUT_LOGIN_LABEL = "checkout-login";
    private static final String BREADCRUBMS = "breadcrumbs";
    private static final String PAYPAL_PAGE_INDICATOR = "isLoginPage";
    private static final String PAYPAL_CONNECT_GLOBAL_ERROR = "paypal.connect.registration.global.error";
    private static final String SAVE_PAYMENT_INFO = "savePaymentInfoUrl";
    private static final String SHOULD_SET_UP_PASSWORD_MESSAGE = "shouldShowSetUpPasswordMessage";
    private static final String SAVE_PAYMENT_INFO_URL = "paypal/connect/noauthentication/savePaymentInfo";
    private static final String SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE = "/paypal/connect/noauthentication/savePaymentInfoAndAddressB2BPage";
    private static final String USER_IS_REGISTERED = "userIsRegistered";
    private static final String IS_PAYMENT_METHOD_SAVED = "isPaymentMethodSaved";
    private static final String IS_ADDRESS_SAVED = "isAddressSaved";
    private static final String REDIRECT_TO_NOAUTHENTICATION_REGISTER = "redirect:/paypal/connect/noauthentication/register/checkout";
    private static final String LOGIN_PAGE = "LOGIN";
    private static final String PAYPAL_CHECKOUT_DATA = "payPalCheckoutData";
    private static final String SHOULD_SAVE_ADDRESS = "shouldSaveAddress";
    private static final String SHOULD_SAVE_PAYMENT_INFO = "shouldSavePaymentInfo";
    private static final String IS_USER_APPROVED = "isUserApproved";
    private static final String REDIRECT_TO_MULTISTEP_CHECKOUT_FIRST_STEP = REDIRECT_TO_MULTISTEP_CHECKOUT + "/payment-type/choose";
    private static final String WAS_USER_REGISTERED = "wasUserRegistered";
    private static final String DID_USER_HAVE_PAYER_ID = "didCustomerHavePayerId";
    private static final String UNVERIFIED_ACCOUNT_ERROR = "paypal.connect.unverified.account.error";
    private static final String EMAIL_ATTRIBUTE = "email";
    private static final String USER_DATA_ATTRIBUTE = "userData";
    private static final String VAULT_PROCESS = "vaultProcessUrl";
    private static final String VAULT_PROCESS_URL = "paypal/connect/noauthentication/response";

    @Resource(name = "payPalCustomerFacade")
    private PayPalCustomerFacade payPalCustomerFacade;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "commonI18NService")
    private CommonI18NService commonI18NService;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultConfigurationService;

    @Resource(name = "countryConverter")
    private Converter<CountryModel, CountryData> countryConverter;

    @Resource(name = "paypalConnectRegistrationValidator")
    private Validator registrationValidator;

    @Resource(name = "b2bRegistrationFacade")
    private B2BRegistrationFacade b2bRegistrationFacade;

    @Resource(name = "payPalConnectService")
    private PayPalConnectService payPalConnectService;

    @Resource(name = "payPalRegistrationUserFacade")
    private PayPalRegistrationUserFacade payPalRegistrationUserFacade;

    @Resource(name = "payPalCustomerAccountService")
    private PayPalCustomerAccountService payPalCustomerAccountService;

    @Resource(name = "payPalB2BRegistrationUserFacade")
    private PayPalB2BRegistrationUserFacade payPalB2BRegistrationUserFacade;

    @Resource(name = "checkoutFlowFacade")
    private CheckoutFlowFacade checkoutFlowFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "payPalCreditCardFacade")
    private PayPalCreditCardFacade payPalCreditCardFacade;

    @Resource(name = "payPalAutoLoginStrategy")
    private PayPalAutoLoginStrategy payPalAutoLoginStrategy;

    @Resource
    private PayPalConnectWithPayPalNotificationFacade payPalConnectWithPayPalNotificationFacade;

    @GetMapping(value = "/register")
    public String getRegister(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, @RequestParam(required = false) String code, final RedirectAttributes redirectAttributes)
        throws CMSItemNotFoundException {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, true);
        return getRegistrationFlow(form, request, response, session, model, code, redirectAttributes);
    }

    @PostMapping(value = "/register")
    public String doRegister(final RegistrationForm form, final BindingResult bindingResult,
        final HttpSession session, final Model model, final RedirectAttributes redirectAttributes)
        throws CMSItemNotFoundException, CustomerAlreadyExistsException, RegistrationNotEnabledException {
        return doRegistrationFlow(form, bindingResult, session, model, redirectAttributes);
    }

    @GetMapping(value = "/register/checkout")
    public String getCheckoutRegister(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, @RequestParam(required = false) String code, final RedirectAttributes redirectAttributes)
        throws CMSItemNotFoundException {
        sessionService.setAttribute(PAYPAL_PAGE_INDICATOR, false);
        model.addAttribute("expressCheckoutAllowed", checkoutFlowFacade.isExpressCheckoutEnabledForStore());
        return getRegistrationFlow(form, request, response, session, model, code, redirectAttributes);
    }

    @PostMapping(value = "/register/checkout")
    public String doCheckoutRegister(final RegistrationForm form, final BindingResult bindingResult,
        final HttpSession session, final Model model, final RedirectAttributes redirectAttributes)
        throws CMSItemNotFoundException, CustomerAlreadyExistsException, RegistrationNotEnabledException {
        return doRegistrationFlow(form, bindingResult, session, model, redirectAttributes);
    }

    @PostMapping(value = "/savePaymentInfo")
    public String doSavePaymentInfo(final RegisterForm form, final BindingResult bindingResult, final HttpServletRequest request,
        final HttpServletResponse response, final Model model) throws CMSItemNotFoundException {
        populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);
        displayingGlobalMessageToRegisteredAndNotRegisteredUser(request);
        printMessageAboutStatusPaymentMethodAndAddress(request);
        sessionService.removeAttribute(ACCESS_TOKEN);
        sessionService.removeAttribute(SHOULD_SAVE_PAYMENT_INFO);
        sessionService.removeAttribute(SHOULD_SAVE_ADDRESS);
        if((boolean) sessionService.getAttribute(IS_USER_APPROVED)){
            sessionService.removeAttribute(IS_USER_APPROVED);
            return processLogin(request, response, sessionService.getAttribute(PAYER_ID));
        }
        sessionService.removeAttribute(IS_USER_APPROVED);
        return REDIRECT_TO_NOAUTHENTICATION_REGISTER;
    }

    @PostMapping(value = "/response")
    public String doHandlePayPalResponse(final PaymentTokenData paymentTokenData, final HttpServletRequest request, final HttpServletResponse response) {
        final String payerId = sessionService.getAttribute(PAYER_ID);
        final PayPalConnectAddressData addressData = sessionService.getAttribute(ADDRESS_DATA);
        if(sessionService.getAttribute(SHOULD_SAVE_PAYMENT_INFO)) {
            try {
                payPalCreditCardFacade.requestPaymentToken(paymentTokenData);
                sessionService.setAttribute(IS_PAYMENT_METHOD_SAVED, true);
            } catch (Exception e) {
                LOG.error("Error during adding payment method for new customer", e);
                sessionService.setAttribute(IS_PAYMENT_METHOD_SAVED, false);
            }
        }
        if(sessionService.getAttribute(SHOULD_SAVE_ADDRESS)) {
            try {
                if (addressData != null) {
                    acceleratorCheckoutFacade.addAddressForNewUser(addressData, payerId);
                    sessionService.setAttribute(IS_ADDRESS_SAVED, true);
                }
            } catch (Exception e) {
                LOG.error("Error during adding address for new customer", e);
                sessionService.setAttribute(IS_ADDRESS_SAVED, false);
            }
        }
        displayingGlobalMessageToRegisteredAndNotRegisteredUser(request);
        printMessageAboutStatusPaymentMethodAndAddress(request);
        sessionService.removeAttribute(ACCESS_TOKEN);
        sessionService.removeAttribute(ADDRESS_DATA);
        sessionService.removeAttribute(SHOULD_SAVE_ADDRESS);
        sessionService.removeAttribute(SHOULD_SAVE_PAYMENT_INFO);
        if(sessionService.getAttribute(IS_USER_APPROVED)){
            sessionService.removeAttribute(IS_USER_APPROVED);
            return processLogin(request, response, sessionService.getAttribute(PAYER_ID));
        }
        sessionService.removeAttribute(IS_USER_APPROVED);
        return REDIRECT_TO_NOAUTHENTICATION_REGISTER;
    }

    @Override
    protected AbstractPageModel getCmsPage() throws CMSItemNotFoundException {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return getContentPageForLabelOrId(LOGIN_LABEL);
        }
        return getContentPageForLabelOrId(CHECKOUT_LOGIN_LABEL);
    }

    @Override
    protected String getSuccessRedirect(HttpServletRequest request, HttpServletResponse response) {
        if (request.getServletPath().equals(REDIRECT_TO_CHECKOUT_PAGE)
                || request.getServletPath().equals("/" + SAVE_PAYMENT_INFO_URL)) {
            return getCheckoutRedirectUrl();
        }
        return REDIRECT_PREFIX + ROOT;
    }

    @Override
    protected String getView() {
        final boolean isLoginPage = sessionService.getAttribute(PAYPAL_PAGE_INDICATOR);
        sessionService.removeAttribute(PAYPAL_PAGE_INDICATOR);
        if (isLoginPage) {
            return Paypalb2baddonControllerConstants.Views.Pages.Account.ACCOUNT_LOGIN_PAGE;
        }
        return Paypalb2baddonControllerConstants.Views.Pages.Checkout.CHECKOUT_LOGIN_PAGE;
    }

    @Override
    protected String getCheckoutRedirectUrl() {
        if (getUserFacade().isAnonymousUser()) {
            return REDIRECT_TO_LOGIN_FOR_CHECKOUT;
        }
        return REDIRECT_TO_MULTISTEP_CHECKOUT_FIRST_STEP;
    }

    private String getRegistrationFlow(final RegisterForm form, final HttpServletRequest request, final HttpServletResponse response,
        final HttpSession session, final Model model, final String code, RedirectAttributes redirectAttributes) throws CMSItemNotFoundException {
        if (code == null) {
            return getDefaultLoginPage(false, session, model);
        }
        String accessToken;
        PayPalConnectUserData userData;
        String email;
        PayPalUserExistB2BData userExistB2BData;
        try {
            if (sessionService.getAttribute(ACCESS_TOKEN) == null) {
                accessToken = payPalConnectService
                        .exchangeAuthorizationCodeToAccessToken(request.getParameter(PAYPAL_CONNECT_AUTHORIZATION_CODE));
            } else {
                accessToken = (String) sessionService.getAttribute(ACCESS_TOKEN);
            }
            userData = payPalConnectService.getUserDataByAccessToken(accessToken);
            email = payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData);
            userExistB2BData = payPalB2BRegistrationUserFacade.isCustomerExistAndApprovedByUID(email);
        } catch (PayPalUnverifiedAccountException e) {
            LOG.error(e.getMessage(), e);
            GlobalMessages.addFlashMessage(redirectAttributes,
                    GlobalMessages.ERROR_MESSAGES_HOLDER,
                    getLocalizedString(UNVERIFIED_ACCOUNT_ERROR));
            return LOGIN_PAGE_REDIRECT;
        }

        if (userExistB2BData.getIsExist() && userExistB2BData.getIsApproved()) {
           return registerApprovedPayPalUser(userData, email, request, response);
        } else if (userExistB2BData.getIsExist()) {
            GlobalMessages.addErrorMessage(model, Localization.getLocalizedString(REGISTER_REQUEST_NOR_APPROVED));
            return getDefaultLoginPage(false, session, model);
        }

        boolean isShouldAddPaymentMethod = defaultConfigurationService.isPayPalVaultEnabled() &&
                defaultConfigurationService.isPayPalEnable();
        sessionService.setAttribute(ACCESS_TOKEN, accessToken);
        final List<CountryData> countries = Converters
            .convertAll(commonI18NService.getAllCountries(), countryConverter);
        model.addAttribute("titles", userFacade.getTitles());
        model.addAttribute("countries", countries);
        populateModelCmsContent(model,
                getContentPageForLabelOrId(CMS_REGISTER_PAGE_NAME));
        sessionService.setAttribute(IS_USER_APPROVED, false);
        sessionService.setAttribute(SHOULD_SAVE_ADDRESS, true);
        sessionService.setAttribute(SHOULD_SAVE_PAYMENT_INFO, isShouldAddPaymentMethod);
        model.addAttribute(new RegistrationForm());
        return Views.PAYPAL_CONNECT_REGISTRATION_PAGE;
    }

    private String registerApprovedPayPalUser(PayPalConnectUserData userData, String email,
                                              HttpServletRequest request, HttpServletResponse response) {
        if (!payPalCustomerAccountService.isCustomerWithPayerIdExist(userData.getPayer_id())) {
            if(!defaultConfigurationService.isEnableLoginViaPayPalToTheExistingUser()){
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.CONF_MESSAGES_HOLDER,
                        DISABLE_LOGIN_VIA_PAYPAL_TO_THE_EXISTING_USER_MESSAGE, null);
                return LOGIN_PAGE_REDIRECT;
            }

            sessionService.setAttribute(USER_DATA_ATTRIBUTE, userData);
            sessionService.setAttribute(EMAIL_ATTRIBUTE, email);
            if (defaultConfigurationService.isPayPalAdditionalSecurityEnabled()) {
                return REDIRECT_PREFIX + CONNECT_LOGIN_ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE;
            } else {
                return REDIRECT_PREFIX + CONNECT_LOGIN_NO_AUTHENTICATION_ACCOUNT_CONNECT;
            }
        }
        if (Objects.nonNull(sessionService.getAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE))) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request), GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.registration.message.set.up.password.for.new.user", null);
            sessionService.removeAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE);
        }
        return processLogin(request, response, userData.getPayer_id());
    }

    private String doRegistrationFlow(final RegistrationForm form, final BindingResult bindingResult,
                                      final HttpSession session, final Model model, RedirectAttributes redirectAttributes) throws CMSItemNotFoundException, RegistrationNotEnabledException {
        populateModelCmsContent(model,
            getContentPageForLabelOrId(CMS_REGISTER_PAGE_NAME));
        model.addAttribute(form);

        registrationValidator.validate(form, bindingResult);
        if (bindingResult.hasErrors()) {
            return Views.PAYPAL_CONNECT_REGISTRATION_PAGE;
        }

        final String accessToken = (String) sessionService.getAttribute(ACCESS_TOKEN);
        final PayPalConnectUserData userData = payPalConnectService.getUserDataByAccessToken(accessToken);

        sessionService.setAttribute(PAYER_ID, userData.getPayer_id());
        sessionService.setAttribute(ADDRESS_DATA, userData.getAddress());
        try {
            b2bRegistrationFacade.register(convertFormAndPayPalDataToRegistrationData(form, userData));
            payPalRegistrationUserFacade
                .setPayerIdToUser(payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData), userData.getPayer_id());
            sessionService.setAttribute(USER_IS_REGISTERED, true);
            sessionService.setAttribute(SHOULD_SET_UP_PASSWORD_MESSAGE, Boolean.TRUE);
            setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(false, false);
        } catch (PayPalUnverifiedAccountException e) {
            LOG.error(e.getMessage(), e);
            GlobalMessages.addFlashMessage(redirectAttributes,
                    GlobalMessages.ERROR_MESSAGES_HOLDER,
                    getLocalizedString(UNVERIFIED_ACCOUNT_ERROR));
            return LOGIN_PAGE_REDIRECT;
        } catch (CustomerAlreadyExistsException e) {
            LOG.error("Failed to register account. Account already exists.", e);
            GlobalMessages.addErrorMessage(model, Localization.getLocalizedString(PAYPAL_CONNECT_GLOBAL_ERROR));
            return getRegistrationView();
        }
        if (defaultConfigurationService.isPayPalConnectAddPaymentMethodFlow()) {
            return REDIRECT_PREFIX + SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE;
        } else {
            populateModelCmsContent(model, getContentPageForLabelOrId(B2bacceleratoraddonWebConstants.CMS_REGISTER_PAGE_NAME));
            model.addAttribute(form);
            GlobalMessages.addConfMessage(model, Localization.getLocalizedString(REGISTER_SUBMIT_CONFIRMATION));
            session.removeAttribute(ACCESS_TOKEN);
            return REDIRECT_TO_NOAUTHENTICATION_REGISTER;
        }
    }

    @RequestMapping(value = "/account-connect", method = RequestMethod.GET)
    public String doConnectPayPalAccount(final HttpServletRequest request, final HttpServletResponse response) {
        PayPalConnectUserData userData = sessionService.getAttribute(USER_DATA_ATTRIBUTE);
        String email = sessionService.getAttribute(EMAIL_ATTRIBUTE);
        PayPalUserExistB2BData userExistB2BData = payPalB2BRegistrationUserFacade.isCustomerExistAndApprovedByUID(email);

        payPalRegistrationUserFacade.setPayerIdToUser(email, userData.getPayer_id());
        payPalConnectWithPayPalNotificationFacade.sendLinkCustomerEmailNotification(email);
        if (!defaultConfigurationService.isPayPalConnectAddPaymentMethodFlow()) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            return processLogin(request, response, userData.getPayer_id());
        }
        boolean isPayPalAddressPresent = payPalCustomerFacade.isPayPalAddressPresent(email, userData.getAddress());

        boolean isPayPalPaymentMethodPresent = payPalCustomerFacade.isPayPalPaymentMethodPresent(email, userData);
        if (isPayPalPaymentMethodPresent && isPayPalAddressPresent) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            return processLogin(request, response, userData.getPayer_id());
        }

        sessionService.setAttribute(IS_USER_APPROVED, userExistB2BData.getIsApproved());
        sessionService.setAttribute(SHOULD_SAVE_ADDRESS, !isPayPalAddressPresent);
        sessionService.setAttribute(SHOULD_SAVE_PAYMENT_INFO, !isPayPalPaymentMethodPresent);
        sessionService.setAttribute(PAYER_ID, userData.getPayer_id());
        sessionService.setAttribute(ADDRESS_DATA, userData.getAddress());
        setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(true, false);

        sessionService.removeAttribute(USER_DATA_ATTRIBUTE);
        sessionService.removeAttribute(EMAIL_ATTRIBUTE);
        return REDIRECT_PREFIX + SAVE_PAYMENT_INFO_AND_ADDRESS_B2B_PAGE;
    }

    @GetMapping(value = "/savePaymentInfoAndAddressB2BPage")
    public String getSavePaymentInfoAndAddressB2BPage(final Model model, final HttpSession session) throws CMSItemNotFoundException {

        setModelAttributesForPaymentAndAddressInfo(model);

        storeCmsPageInModel(model, getCmsPage());
        setUpMetaDataForContentPage(model, (ContentPageModel) getCmsPage());

        if (sessionService.getAttribute(USER_IS_REGISTERED) != null) {
            GlobalMessages.addConfMessage(model, Localization.getLocalizedString(REGISTER_SUBMIT_CONFIRMATION));
        }
        sessionService.removeAttribute(USER_IS_REGISTERED);

        return Views.PAYPAL_CONNECT_SAVE_PAYMENT_INFO_PAGE;
    }

    @ExceptionHandler(PayPalConnectException.class)
    public String handlerPayPalConnectException(HttpServletRequest request, PayPalConnectException e) {
        GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.access.error" , null);
        return request.getServletPath().contains(PAYPAL_CONNECT_SERVLET_PATH)
                ? LOGIN_CHECKOUT_PAGE_REDIRECT : LOGIN_PAGE_REDIRECT;
    }

    private B2BRegistrationData convertFormAndPayPalDataToRegistrationData(
        final RegistrationForm form, PayPalConnectUserData userData) {
        final B2BRegistrationData registrationData = new B2BRegistrationData();
        BeanUtils.copyProperties(form, registrationData);
        registrationData.setName(userData.getName());
        registrationData.setEmail(payPalRegistrationUserFacade.getEmailFromPayPalUserData(userData));
        return registrationData;
    }

    private void populateModelCmsContent(final Model model, final ContentPageModel contentPageModel) {

        storeCmsPageInModel(model, contentPageModel);
        setUpMetaDataForContentPage(model, contentPageModel);

        final Breadcrumb registrationBreadcrumbEntry = new Breadcrumb("#",
            getMessageSource().getMessage(SCP_LINK_CREATE_ACCOUNT, null, getI18nService().getCurrentLocale()), null);
        model.addAttribute(BREADCRUBMS, Collections.singletonList(registrationBreadcrumbEntry));
    }

    private String processLogin(final HttpServletRequest request, final HttpServletResponse response, final String payerId) {
        final CustomerData customer = payPalCustomerAccountService.getCustomerDataByPayerId(payerId);

        String expiredStatus = payPalCreditCardFacade.getCardsExpirationStatus(customer.getUid());
        if (expiredStatus.equals(ExpirationStatus.EXPIRED.getCode())) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.INFO_MESSAGES_HOLDER, Paypalb2baddonWebConstants.EXPIRED_MESSAGE, null);
        }
        if (expiredStatus.equals(ExpirationStatus.EXPIRE_SOON.getCode())) {
            GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                    GlobalMessages.INFO_MESSAGES_HOLDER,  Paypalb2baddonWebConstants.EXPIRED_SOON_MESSAGE, null);
        }

        payPalAutoLoginStrategy.login(customer.getUid(), request, response);
        return getSuccessRedirect(request, response);
    }

    protected CheckoutFlowFacade getCheckoutFlowFacade() {
        return checkoutFlowFacade;
    }

    private String getRegistrationView() {
        return B2bacceleratoraddonWebConstants.Views.REGISTRATION_PAGE;
    }

    private void printMessageAboutStatusPaymentMethodAndAddress(final HttpServletRequest request) {
        if (sessionService.getAttribute(IS_PAYMENT_METHOD_SAVED) != null) {
            if ((boolean) sessionService.getAttribute(IS_PAYMENT_METHOD_SAVED)) {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.saved.payment.method", null);
            } else {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.saved.payment.method.error", null);
            }
        }
        if (sessionService.getAttribute(IS_ADDRESS_SAVED) != null) {
            if ((boolean) sessionService.getAttribute(IS_ADDRESS_SAVED)) {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.INFO_MESSAGES_HOLDER, "paypal.connect.saved.address", null);
            } else {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.ERROR_MESSAGES_HOLDER, "paypal.connect.saved.address.error", null);
            }
        }
        sessionService.removeAttribute(IS_PAYMENT_METHOD_SAVED);
        sessionService.removeAttribute(IS_ADDRESS_SAVED);
    }

    private void setModelAttributesForPaymentAndAddressInfo(Model model) {
        final PayPalCheckoutData checkoutData = acceleratorCheckoutFacade.getPayPalCheckoutData(LOGIN_PAGE);

        model.addAttribute(VAULT_PROCESS, VAULT_PROCESS_URL);
        model.addAttribute(PAYPAL_CHECKOUT_DATA, checkoutData);
        model.addAttribute(SAVE_PAYMENT_INFO, SAVE_PAYMENT_INFO_URL);
        model.addAttribute(SHOULD_SAVE_ADDRESS, sessionService.getAttribute(SHOULD_SAVE_ADDRESS));
        model.addAttribute(SHOULD_SAVE_PAYMENT_INFO, sessionService.getAttribute(SHOULD_SAVE_PAYMENT_INFO));
    }

    private void setSessionAttributeForGlobalMessageToRegisteredAndNotRegisteredUser(boolean wasUserRegistered, boolean didUserHavePayerId) {
        sessionService.setAttribute(WAS_USER_REGISTERED, wasUserRegistered);
        sessionService.setAttribute(DID_USER_HAVE_PAYER_ID, didUserHavePayerId);
    }

    private void displayingGlobalMessageToRegisteredAndNotRegisteredUser(HttpServletRequest request) {
        if (Objects.nonNull(sessionService.getAttribute(WAS_USER_REGISTERED))
                && Objects.nonNull(sessionService.getAttribute(DID_USER_HAVE_PAYER_ID))) {
            boolean wasUserRegistered = sessionService.getAttribute(WAS_USER_REGISTERED);
            boolean didUserHavePayerId = sessionService.getAttribute(DID_USER_HAVE_PAYER_ID);
            if (wasUserRegistered && !didUserHavePayerId) {
                GlobalMessages.addFlashMessage(RequestContextUtils.getOutputFlashMap(request),
                        GlobalMessages.CONF_MESSAGES_HOLDER, "paypal.connect.login.linked.accounts", null);
            }
        }
        sessionService.removeAttribute(WAS_USER_REGISTERED);
        sessionService.removeAttribute(DID_USER_HAVE_PAYER_ID);
    }
}
