package com.paypal.hybris.b2baddon.controllers.pages;

import com.google.gson.Gson;
import com.paypal.enums.PayPalPageType;
import com.paypal.enums.PayPalPaymentProvider;
import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.core.util.builder.GenericBuilder;
import com.paypal.hybris.data.ApplePayAddressDetailsData;
import com.paypal.hybris.data.PayPalSDKData;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import com.paypal.hybris.core.service.impl.DefaultPayPalPaymentInfoService;
import com.paypal.hybris.facade.facades.PayPalClientTokenFacade;
import com.paypal.hybris.facade.facades.PayPalConfigurationFacade;
import com.paypal.hybris.facade.facades.PayPalFraudNetFacade;
import com.paypal.hybris.facade.facades.PayPalSDKFacade;
import com.paypal.hybris.facade.facades.PayPalSessionPaymentMethodFacade;
import com.paypal.hybris.facade.facades.StylesConfigurationFacade;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalSetUpPasswordFacade;
import de.hybris.platform.acceleratorservices.storefront.data.JavaScriptVariableData;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.servicelayer.services.CMSComponentService;
import de.hybris.platform.commercefacades.customer.CustomerFacade;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.user.data.CustomerData;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercefacades.user.data.AddressData;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commercefacades.user.UserFacade;
import de.hybris.platform.servicelayer.i18n.CommonI18NService;
import de.hybris.platform.servicelayer.session.SessionService;
import org.springframework.ui.ModelMap;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.IS_ANONYMOUS_USER;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.IS_SESSION_PAYMENT_PAYPAL_EXIST;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.IS_SESSION_PAYMENT_VENMO_EXIST;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.PAYMENT_INFOS;
import static com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants.SESSION_PAYMENT_METHOD;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_ADD_TO_CART_POPUP_PAGE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_BILLING_PAGE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CART_PAGE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_CART_POPUP_PAGE_TYPE;
import static com.paypal.hybris.core.constants.PaypalcoreConstants.PAYPAL_SUBSCRIPTION_ID_PLACEHOLDER;
import static com.paypal.hybris.core.enums.Location.CART;
import static com.paypal.hybris.core.enums.Location.MARK;
import static com.paypal.hybris.core.enums.Location.MINICART;

public class PayPalBeforeViewHandler implements BeforeViewHandlerAdaptee {

    private static final String ADDON_PREFIX_B2B = "addon:/b2bacceleratoraddon/";
    private static final String B2B_ADD_TO_CART_POPUP_PAGE = "fragments/cart/addToCartPopup";
    private static final String B2B_CART_POPUP_PAGE = "addon:/paypalb2baddon/fragments/cart/cartPopup";
    private static final String PAYPAL_CORELATION_ID = "correlationId";
    private static final String PAYPAL_PAGE_ID = "pageId";
    private static final String B2B_SILENT_ORDER_POST_PAGE = "pages/checkout/multi/silentOrderPostPage";
    private static final String B2B_CHECKOUT_SUMMARY_PAGE =
        ADDON_PREFIX_B2B + "pages/checkout/multi/checkoutSummaryPage";
    private static final String B2B_CHECKOUT_CONFIRMATION_PAGE =
        ADDON_PREFIX_B2B + "pages/checkout/checkoutConfirmationPage";
    private static final String B2B_CART_PAGE = "pages/cart/cartPage";
    private static final String ACCOUNT_LAYOUT_PAGE = "pages/account/accountLayoutPage";
    private static final String HOSTED_FIELDS_STYLES= "hostedFieldsStyles";
    private static final String MARK_APPLE_APPLE_PAY_STYLES = "applePayButtonConfigMark";
    private static final String CART_APPLE_PAY_STYLES = "applePayButtonConfigCart";
    private static final String MINI_CART_APPLE_PAY_STYLES = "applePayButtonConfigMiniCart";
    private static final String ADD_PAYMENT_BUTTON_ENABLED = "isAddPaymentButtonEnabled";
    private static final String IS_VAULT_ENABLED = "isVaultEnabled";
    private static final String IS_REPLENISHMENT_AVAILABLE = "isReplenishmentAvailable";
    private static final String SAVE_ORDER_FLOW_ENABLED = "saveOrderFlowEnabled";
    private static final String CART_DATA_TOTAL_PRICE = "cartDataTotalPrice";
    private static final String SHOULD_SET_UP_PASSWORD_FORM_DISPLAYED = "shouldSetUpPasswordFormDisplayed";
    private static final String PAYPAL_BUTTON_CONFIG = "paypalButtonConfig";
    private static final String COMMIT = "commit";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String DATA_USER_ID_TOKEN = "dataUserIdToken";
    private static final String PAY_PAL_SDK_URL = "payPalSDKUrl";
    private static final String PAY_PAL_MY_ACCOUNT_SDK_URL = "payPalMyAccountSDKUrl";
    private static final String PARTNER_ATTRIBUTION_ID = "partnerAttributionId";
    private static final String THREE_DS_VERIFICATION_TYPE = "threeDSVerificationType";
    private static final String PAYPAL_PLUGIN_CONFIGURATION = "payPalPluginConfiguration";
    private static final String PAYPAL_ESSENTIAL_CONFIGURATION = "payPalEssentialConfiguration";
    private static final String CART_DATA = "cartData";
    private static final String EMPTY_STRING = "";
    private static final String USER_NAME = "userName";
    private static final String PAYPAL_CONNECT_ADD_PAYMENT_PAGE = "addon:/paypalb2baddon/pages/login/savePaymentInfo";
    private static final String CURRENCY = "currency";
    private static final String LOCALE = "locale";
    private static final String PAGE = "page";
    private static final String IS_AVAILABLE_FOR_EXPRESS_CHECKOUT = "isAvailableForExpressCheckout";
    private static final String DEFAULT_SHIPPING_ADDRESS = "defaultApplePayShippingAddress";
    private static final String CHOSEN_APPLE_PAY_SHIPPING_ADDRESS = "chosenApplePayShippingAddress";
    private static final String IS_SAVED_CREDIT_CARDS_AMOUNT_LIMITED = "isSavedCreditCardsAmountLimited";
    private static final String IS_SAVED_PAYPAL_ACCOUNTS_AMOUNT_LIMITED = "isSavedPayPalAccountsAmountLimited";
    private static final String IS_CHANGE_PAYMENT_BUTTON_ACTIVE = "isChangePaymentButtonActive";
    private static final String DATA_USER_ID_TOKEN_FOR_MY_ACCOUNT = "dataUserIdTokenForMyAccount";

    @Resource(name = "cmsComponentService")
    private CMSComponentService cmsComponentService;

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource
    private PayPalConfigurationFacade payPalConfigurationFacade;

    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    @Resource(name = "sessionService")
    private SessionService sessionService;

    @Resource(name = "userFacade")
    private UserFacade userFacade;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService payPalConfigurationService;

    @Resource(name = "payPalSetUpPasswordFacade")
    private DefaultPayPalSetUpPasswordFacade defaultPayPalSetUpPasswordFacade;

    @Resource(name = "payPalSessionPaymentMethodFacade")
    private PayPalSessionPaymentMethodFacade payPalSessionPaymentMethodFacade;

    @Resource
    private DefaultPayPalPaymentInfoService paymentInfoService;

    @Resource
    private Populator<AddressData, ApplePayAddressDetailsData> applePayAddressDataReversePopulator;

    @Resource(name = "payPalFraudNetFacade")
    private PayPalFraudNetFacade payPalFraudNetFacade;

    @Resource(name = "payPalClientTokenFacade")
    private PayPalClientTokenFacade payPalClientTokenFacade;

    @Resource(name = "defaultStylesConfigurationFacade")
    private StylesConfigurationFacade stylesConfigurationFacade;

    @Resource(name = "defaultCommonI18NService")
    private CommonI18NService commonI18NService;

    @Resource(name = "payPalSDKFacade")
    private PayPalSDKFacade payPalSDKFacade;

    @Resource(name = "customerFacade")
    protected CustomerFacade customerFacade;

    @Override
    public String beforeView(HttpServletRequest request, HttpServletResponse response, ModelMap model, String viewName)
        throws Exception {

        prepareViewForAllPages(model);
        preparePaypalSdkData(model, viewName);

        if (B2B_SILENT_ORDER_POST_PAGE.equals(viewName)) {
            return prepareViewForSilentOrderPage(model);
        } else if (B2B_CHECKOUT_SUMMARY_PAGE.equals(viewName)) {
            return prepareViewForCheckoutSummaryPage(model);
        } else if (B2B_CHECKOUT_CONFIRMATION_PAGE.equals(viewName)) {
            return Paypalb2baddonControllerConstants.Views.Pages.Checkout.CHECKOUT_CONFIRMATION_PAGE;
        } else if (B2B_ADD_TO_CART_POPUP_PAGE.equals(viewName)) {
            return prepareViewForAddToCartPopupPage(model, viewName);
        } else if (B2B_CART_PAGE.equals(viewName)) {
            return prepareViewForCartPage(model, viewName);
        } else if (B2B_CART_POPUP_PAGE.equals(viewName)) {
            return prepareViewForCartPopupPage(model);
        } else if (ACCOUNT_LAYOUT_PAGE.equals(viewName)) {
            return prepareViewForAccount(model);
        }
        return viewName;
    }

    private void prepareViewForAllPages(ModelMap model) {
        boolean isAnonymousUser = userFacade.isAnonymousUser();
        model.addAttribute(PAYPAL_PLUGIN_CONFIGURATION, payPalConfigurationFacade.getPayPalPluginConfigurationData());
        model.addAttribute(PAYPAL_ESSENTIAL_CONFIGURATION, payPalConfigurationFacade.getPayPalEssentialConfigurationData());
        model.addAttribute(IS_ANONYMOUS_USER, isAnonymousUser);
        addJavaScriptVariable(IS_ANONYMOUS_USER, String.valueOf(isAnonymousUser), model);
    }

    private void preparePaypalSdkData(ModelMap model, String viewName){
        PayPalSDKData payPalSDKData;
        if (PAYPAL_CONNECT_ADD_PAYMENT_PAGE.equals(viewName)) {
            payPalSDKData = payPalSDKFacade.getPayPalSDKData(PayPalPageType.LOGIN);
            addJavaScriptVariable(DATA_USER_ID_TOKEN, payPalSDKData.getDataUserIdToken(), model);
        } else {
            payPalSDKData = payPalSDKFacade.getPayPalSDKData();
            addJavaScriptVariable(DATA_USER_ID_TOKEN, payPalSDKData.getDataUserIdToken(), model);
        }

        addJavaScriptVariable(CLIENT_TOKEN, payPalSDKData.getClientToken(), model);
        addJavaScriptVariable(PARTNER_ATTRIBUTION_ID, payPalSDKData.getPartnerAttributionId(), model);
        addJavaScriptVariable(PAY_PAL_SDK_URL, payPalSDKData.getPayPalSDKUrl(), model);

        if (ACCOUNT_LAYOUT_PAGE.equals(viewName)) {
            PayPalSDKData payPalMyAccountSDKData = payPalSDKFacade.getPayPalSDKData(PayPalPageType.ACCOUNT);
            addJavaScriptVariable(DATA_USER_ID_TOKEN_FOR_MY_ACCOUNT, payPalMyAccountSDKData.getDataUserIdToken(), model);
            addJavaScriptVariable(PAY_PAL_MY_ACCOUNT_SDK_URL, payPalMyAccountSDKData.getPayPalSDKUrl(), model);
        }

        if (payPalConfigurationService.isApplePayEnable()) {
            prepareApplePay(model, viewName);
        }
    }

    private void prepareApplePay(ModelMap model, String viewName) {
        CartData cartData = cartFacade.getSessionCart();
        ApplePayAddressDetailsData applePayAddressDetailsData = new ApplePayAddressDetailsData();
        Gson parser = new Gson();
        String[] pageUrl = viewName.split("/");
        String pageName = pageUrl[pageUrl.length - 1];

        Optional<AddressData> defaultShippingAddress = Optional.ofNullable(customerFacade.getCurrentCustomer()).map(CustomerData::getDefaultShippingAddress);
        Optional<AddressData> chosenShippingAddress = Optional.ofNullable(cartFacade.getSessionCart()).map(CartData::getDeliveryAddress);

        addJavaScriptVariable(CURRENCY, cartData.getTotalPrice().getCurrencyIso(), model);
        addJavaScriptVariable(LOCALE, ((Locale) sessionService.getAttribute(LOCALE)).getLanguage(), model);
        addJavaScriptVariable(PAGE, pageName, model);

        defaultShippingAddress.ifPresent(addressData -> {
            applePayAddressDataReversePopulator.populate(addressData, applePayAddressDetailsData);
            addJavaScriptVariable(DEFAULT_SHIPPING_ADDRESS,  parser.toJson(applePayAddressDetailsData), model);
        });
        chosenShippingAddress.ifPresent(addressData -> {
            applePayAddressDataReversePopulator.populate(addressData, applePayAddressDetailsData);
            addJavaScriptVariable(CHOSEN_APPLE_PAY_SHIPPING_ADDRESS,  parser.toJson(applePayAddressDetailsData), model);
        });

        model.addAttribute(IS_AVAILABLE_FOR_EXPRESS_CHECKOUT, String.valueOf(isAvailableForExpressCheckout()));
    }

    private boolean isAvailableForExpressCheckout() {
        return payPalConfigurationService.isApplePayOnExpressCheckoutEnable()
                && !userFacade.isAnonymousUser();
    }

    private String prepareViewForSilentOrderPage(ModelMap model) {
        addJavaScriptVariable(USER_NAME, Optional.ofNullable(customerFacade.getCurrentCustomer().getName()).orElse(EMPTY_STRING) , model);
        addJavaScriptVariable(COMMIT, String.valueOf(payPalConfigurationService.isCommitEnabled()), model);
        addJavaScriptVariable(THREE_DS_VERIFICATION_TYPE, payPalConfigurationService.getPayPal3DSVerificationType(), model);
        addJavaScriptVariable(IS_CHANGE_PAYMENT_BUTTON_ACTIVE, String.valueOf(paymentInfoService.isChangePaymentButtonActive()), model);
        model.addAttribute(IS_SAVED_CREDIT_CARDS_AMOUNT_LIMITED, paymentInfoService.isSavedCreditCardsAmountLimited());
        model.addAttribute(IS_SAVED_PAYPAL_ACCOUNTS_AMOUNT_LIMITED, paymentInfoService.isSavedPayPalAccountsAmountLimited());
        final List<CCPaymentInfoData> ccPaymentInfos = acceleratorCheckoutFacade.getAvailableCCPaymentInfosForCurrentUser();
        if (payPalConfigurationService.isPayPalHostedFieldsEnabled()) {
            model.addAttribute(CLIENT_TOKEN, payPalClientTokenFacade.getClientToken());
        }
        if (payPalConfigurationService.isFraudNetEnabled()){
            generateFraudNetUid(PAYPAL_BILLING_PAGE_TYPE, model);
        }
        model.addAttribute(PAYPAL_BUTTON_CONFIG, stylesConfigurationFacade.getPayPalStylesConfiguration(MARK.name()));
        model.addAttribute(MARK_APPLE_APPLE_PAY_STYLES, stylesConfigurationFacade.getApplePayStylesConfiguration(MARK.name()));
        model.addAttribute(HOSTED_FIELDS_STYLES, stylesConfigurationFacade.getHostedFieldsStylesConfiguration());
        model.addAttribute(SESSION_PAYMENT_METHOD, payPalSessionPaymentMethodFacade.getSessionPaymentMethod());
        model.addAttribute(PAYMENT_INFOS, ccPaymentInfos);
        model.addAttribute(IS_REPLENISHMENT_AVAILABLE, payPalConfigurationService.isReplenishmentAvailable());
        return Paypalb2baddonControllerConstants.Views.Pages.MultiStepCheckout.SILENT_ORDER_POST_PAGE;
    }

    private String prepareViewForCheckoutSummaryPage(ModelMap model) {
        final boolean isReplenishment = isReplenishmentEnabled();
        model.addAttribute(SAVE_ORDER_FLOW_ENABLED, payPalConfigurationFacade.getPayPalConfigurationData().isSaveOrderFlow());
        model.addAttribute(IS_REPLENISHMENT_AVAILABLE, isReplenishment);
        return Paypalb2baddonControllerConstants.Views.Pages.MultiStepCheckout.CHECKOUT_SUMMARY_PAGE;
    }

    private String prepareViewForAddToCartPopupPage(ModelMap model, String viewName) throws CMSItemNotFoundException {
        CartData cartData = cartFacade.getSessionCart();
        addExpressCheckoutComponent(model);
        if (payPalConfigurationService.isFraudNetEnabled()) {
            generateFraudNetUid(PAYPAL_ADD_TO_CART_POPUP_PAGE_TYPE, model);
        }
        model.addAttribute(PAYPAL_BUTTON_CONFIG, stylesConfigurationFacade.getPayPalStylesConfiguration(MINICART.name()));
        model.addAttribute(MINI_CART_APPLE_PAY_STYLES, stylesConfigurationFacade.getApplePayStylesConfiguration(MINICART.name()));
        model.addAttribute(CART_DATA_TOTAL_PRICE, cartFacade.getMiniCart().getTotalPrice());
        model.addAttribute(CART_DATA, cartData);

        return Paypalb2baddonControllerConstants.Views.Fragments.Cart.ADD_TO_CART_POPUP;
    }

    private String prepareViewForCartPage(ModelMap model, String viewName) throws CMSItemNotFoundException {
        addExpressCheckoutComponent(model);
        if (payPalConfigurationService.isFraudNetEnabled()) {
            generateFraudNetUid(PAYPAL_CART_PAGE_TYPE, model);
        }
        model.addAttribute(PAYPAL_BUTTON_CONFIG, stylesConfigurationFacade.getPayPalStylesConfiguration(CART.name()));
        model.addAttribute(CART_APPLE_PAY_STYLES, stylesConfigurationFacade.getApplePayStylesConfiguration(CART.name()));

        return viewName;
    }

    private String prepareViewForCartPopupPage(ModelMap model) throws CMSItemNotFoundException {
        addExpressCheckoutComponent(model);
        if (payPalConfigurationService.isFraudNetEnabled()) {
            generateFraudNetUid(PAYPAL_CART_POPUP_PAGE_TYPE, model);
        }
        model.addAttribute(PAYPAL_BUTTON_CONFIG, stylesConfigurationFacade.getPayPalStylesConfiguration(MINICART.name()));
        model.addAttribute(MINI_CART_APPLE_PAY_STYLES, stylesConfigurationFacade.getApplePayStylesConfiguration(MINICART.name()));

        return Paypalb2baddonControllerConstants.Views.Fragments.Cart.CART_POPUP;
    }

    private String prepareViewForAccount(ModelMap model) {
        model.addAttribute(SHOULD_SET_UP_PASSWORD_FORM_DISPLAYED, defaultPayPalSetUpPasswordFacade.isSetUpPasswordForm());
        if (ifAnyPaymentMethodAvailable()) {
            model.addAttribute(CLIENT_TOKEN, payPalClientTokenFacade.getClientToken());
            model.addAttribute(ADD_PAYMENT_BUTTON_ENABLED, true);
            addJavaScriptVariable(IS_VAULT_ENABLED, String.valueOf(payPalConfigurationService.isPayPalVaultEnabled()), model);
        } else if (!isHostedFieldsAvailableToSave() && !isPayPalAvailableToSave()) {
            GlobalMessages.addFlashMessage(model, GlobalMessages.INFO_MESSAGES_HOLDER,
                    "paymentMethod.paypal.and.hostedFields.disable.message", null);
        } else if (paymentInfoService.isSavedCreditCardsAmountLimited() || paymentInfoService.isSavedPayPalAccountsAmountLimited()) {
            GlobalMessages.addFlashMessage(model, GlobalMessages.INFO_MESSAGES_HOLDER,
                    "text.account.saved.payment.amount.limited", null);
        }
        return ACCOUNT_LAYOUT_PAGE;
    }

    private boolean ifAnyPaymentMethodAvailable() {
        return (isHostedFieldsAvailableToSave() && !paymentInfoService.isSavedCreditCardsAmountLimited())
                || isPayPalAvailableToSave() && !paymentInfoService.isSavedPayPalAccountsAmountLimited();
    }

    private boolean isHostedFieldsAvailableToSave() {
        return payPalConfigurationService.isPayPalHostedFieldsEnabled()
                && payPalConfigurationService.isPayPalHostedFieldsVaultEnabled();
    }

    private boolean isPayPalAvailableToSave() {
        return payPalConfigurationService.isPayPalVaultEnabled()
                && payPalConfigurationService.isPayPalEnable();
    }

    private void addJavaScriptVariable(String key, String value, ModelMap model) {
        JavaScriptVariableData javaScriptVariableData = GenericBuilder.of(JavaScriptVariableData::new)
                .with(JavaScriptVariableData::setQualifier, key)
                .with(JavaScriptVariableData::setValue, value).build();
        ((Map<String, List<JavaScriptVariableData>>)model.get("jsAddOnsVariables")).get("paypalb2baddon").add(javaScriptVariableData);
    }

    private void generateFraudNetUid(String pageType, ModelMap model) {
        String correlationId = payPalFraudNetFacade.getCorrelationId();
        payPalFraudNetFacade.saveCorrelationId(correlationId);
        model.addAttribute(PAYPAL_CORELATION_ID, correlationId);
        model.addAttribute(PAYPAL_PAGE_ID, payPalFraudNetFacade.getPageId(pageType));
    }

    private void addExpressCheckoutComponent(final ModelMap model) {
        model.addAttribute(IS_SESSION_PAYMENT_PAYPAL_EXIST, payPalSessionPaymentMethodFacade.isPayPalSessionPaymentForExpressCheckoutExist());
        model.addAttribute(IS_SESSION_PAYMENT_VENMO_EXIST, payPalSessionPaymentMethodFacade.isVenmoSessionPaymentForExpressCheckoutExist());
    }

    private boolean isReplenishmentEnabled() {
        CCPaymentInfoData paymentInfoData = cartFacade.getSessionCart().getPaymentInfo();
        return paymentInfoData != null && isValidPaymentProvider(paymentInfoData)
                && isValidSubscription(paymentInfoData);
    }

    private boolean isValidPaymentProvider(CCPaymentInfoData paymentInfoData) {
        return PayPalPaymentProvider.PAYPAL_HOSTED_FIELDS.equals(paymentInfoData.getPaymentProvider())
                || PayPalPaymentProvider.PAYPAL.equals(paymentInfoData.getPaymentProvider());
    }

    private boolean isValidSubscription(CCPaymentInfoData paymentInfoData) {
        return paymentInfoData.getSubscriptionId() != null
                && !PAYPAL_SUBSCRIPTION_ID_PLACEHOLDER.equals(paymentInfoData.getSubscriptionId());
    }
}
