package com.paypal.hybris.b2baddon.controllers.pages;


import com.paypal.hybris.b2baddon.constants.Paypalb2baddonWebConstants;
import com.paypal.hybris.core.enums.ExpirationStatus;
import com.paypal.hybris.facade.facades.PayPalCreditCardFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.addonsupport.interceptors.BeforeViewHandlerAdaptee;
import de.hybris.platform.servicelayer.user.UserService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.ui.ModelMap;

public class PayPalBeforeNotificationViewHandler implements BeforeViewHandlerAdaptee {

    private static final String LOGIN_PAGE_REGEX = "(/login(/checkout)?)";

    @Resource(name = "userService")
    private UserService userService;

    @Resource(name = "payPalCreditCardFacade")
    private PayPalCreditCardFacade saveCardFacade;

    @Override
    public String beforeView(HttpServletRequest request, HttpServletResponse response, ModelMap model, String viewName) throws Exception {
        String referer = request.getHeader(HttpHeaders.REFERER);
        String previousView = referer != null ? referer : "";
        Matcher matcher = Pattern.compile(LOGIN_PAGE_REGEX).matcher(previousView);
        if (!userService.isAnonymousUser(userService.getCurrentUser())
            && matcher.find()) {
            String expiredStatus = saveCardFacade.getCardsExpirationStatus();
            if (expiredStatus.equals(ExpirationStatus.EXPIRED.getCode())) {
                GlobalMessages.addFlashMessage(model, GlobalMessages.INFO_MESSAGES_HOLDER,
                        Paypalb2baddonWebConstants.EXPIRED_MESSAGE, null);
            }
            if (expiredStatus.equals(ExpirationStatus.EXPIRE_SOON.getCode())) {
                GlobalMessages.addFlashMessage(model, GlobalMessages.INFO_MESSAGES_HOLDER,
                        Paypalb2baddonWebConstants.EXPIRED_SOON_MESSAGE, null);
            }
        }
        return viewName;
    }
}
