package com.paypal.hybris.b2baddon.controllers.cms;

import com.paypal.hybris.b2baddon.controllers.Paypalb2baddonControllerConstants;
import com.paypal.hybris.b2baddon.model.PayPalCreditMessageComponentB2BModel;
import com.paypal.hybris.core.service.PayPalConfigurationService;
import com.paypal.hybris.facade.facades.PayPalAcceleratorCheckoutFacade;
import de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController;
import de.hybris.platform.commercefacades.order.CartFacade;
import de.hybris.platform.commercefacades.order.data.CartData;
import de.hybris.platform.commerceservices.request.mapping.annotation.RequestMappingOverride;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;



@Controller("PayPalCreditMessageComponentB2BController")
@Scope("tenant")
@RequestMapping(value = Paypalb2baddonControllerConstants.Actions.Cms.PAYPAL_CREDIT_MESSAGE_COMPONENT)
public class PayPalCreditMessageComponentController extends
    AbstractCMSAddOnComponentController<PayPalCreditMessageComponentB2BModel> {

    private static final String TOTAL_PRICE = "totalPrice";
    private static final String CART_DATA = "cartData";
    private static final String IS_CREDIT_MESSAGES_ENABLED = "isCreditMessagesEnabled";
    private static final String IS_PICKUP_IN_STORE_FLOW = "isPickupInStoreFlow";

    @Resource(name = "cartFacade")
    private CartFacade cartFacade;

    @Resource(name = "payPalConfigurationService")
    private PayPalConfigurationService defaultPayPalConfigurationService;


    @Resource(name = "defaultPayPalAcceleratorCheckoutFacade")
    private PayPalAcceleratorCheckoutFacade acceleratorCheckoutFacade;

    /*
     * (non-Javadoc)
     *
     * @see
     * de.hybris.platform.addonsupport.controllers.cms.AbstractCMSAddOnComponentController#fillModel(javax.servlet.http
     * .HttpServletRequest, org.springframework.ui.Model,
     * de.hybris.platform.cms2.model.contents.components.AbstractCMSComponentModel)
     */
    @Override
    protected void fillModel(final HttpServletRequest request, final Model model,
        final PayPalCreditMessageComponentB2BModel component) {
        final CartData cartData = cartFacade.getMiniCart();
        model.addAttribute(TOTAL_PRICE, cartData.getTotalPrice());
        model.addAttribute(CART_DATA, cartData);
        model.addAttribute(IS_CREDIT_MESSAGES_ENABLED, component.getEnabled());
        model.addAttribute(IS_PICKUP_IN_STORE_FLOW, acceleratorCheckoutFacade.isPickupInStore());
    }

    @Override
    @RequestMappingOverride
    @RequestMapping
    public String handleGet(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
        return super.handleGet(request, response, model);
    }

}

