ACC.unlinkpaypal = {
    _autoload: [
        [`unlinkPayPal`, $(`a[title="Unlink PayPal"]`).length !== 0 ]
    ],

    unlinkPayPal: function () {
        $(`a[title="Unlink PayPal"]`).on(`click`, function (e) {
            e.preventDefault();
            const baseUrl = $(this).attr(`href`);
            $.get(baseUrl + PAYPAL_CONSTANTS.UNLINK_PAYPAL_VERIFY_URL, function (response) {
                if (!response.isPasswordForSingleAuthenticationActive) {
                    window.location.href = `${baseUrl}?url=${PAYPAL_CONSTANTS.UPDATE_PASSWORD_URL}&isUnlinked=false`;
                }else{
                    ACC.unlinkpaypal.showUnlinkPayPalPopup(baseUrl);
                }
            });
        });
    },

    showUnlinkPayPalPopup: function(baseUrl) {
        const content = ACC.unlinkpaypal.prepareHtmlForUnlinkPopup();
        const title = ACC.addons.paypaladdon[`unlink.login.with.paypal.title`];
        const isMobile = window.innerWidth <= 600;
        const config = {
            width: isMobile ? `80%` : `40%`,
            height: isMobile ? `45%` : `47%`,
            closeButton: false,
            title: title,
            className: `custom-colorbox`,
            html: content,

            onComplete: function() {
                $(`#colorbox-ok`).on(`click`, function() {
                    $.colorbox.close();
                    $.post(baseUrl + PAYPAL_CONSTANTS.UNLINK_PAYPAL_URL, function() {
                        window.location.href = `${baseUrl}?isUnlinked=true`;
                    });
                });

                $(`#colorbox-cancel`).on(`click`, function() {
                    $.colorbox.close();
                });
            }
        };
        ACC.colorbox.open(title, config);
    },

    prepareHtmlForUnlinkPopup: function() {
        return `<div id="colorbox-content">
                <p>${ACC.addons.paypaladdon[`unlink.login.with.paypal.message`]}</p>
                </div>
                <div id="colorbox-buttons">
                <button class="unlinkPopupButton" id="colorbox-ok">${ACC.addons.paypaladdon[`unlink.login.with.paypal.ok.button`]}</button>
                <button class="unlinkPopupButton" id="colorbox-cancel">${ACC.addons.paypaladdon[`unlink.login.with.paypal.cancel.button`]}</button>
                </div>`;
    },

}
