ACC.paypalSavePayment = {

    _autoload: [
        ["renderPayPalButton", $(PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER).length !== 0
                                    && isVaultEnabled === "true"]
    ],

    renderPayPalButton: async function () {
               await ACC.paypalSDKloader.paypalSDKPromiseMyAccount;

               var funding = 'paypal';
               var container = PAYPAL_CONSTANTS.HOSTED_FIELDS.PAYMENT_METHOD_BUTTON_CONTAINER;
               var flow = PAYPAL_CONSTANTS.FLOWS.MY_ACCOUNT_FLOW;
               var buttonStyle;

               if (paypalSdkOnAccount.isFundingEligible(funding)) {
                   buttonStyle = this.getButtonStyle(funding, buttonStyle);
                   var createVaultSetupTokenResponse;
                   paypalSdkOnAccount.Buttons({
                       style: buttonStyle,

                       fundingSource: funding,

                       createVaultSetupToken: async () => {
                           const result = await fetch(ACC.config.encodedContextPath + "/paypal/vault/setup-token?CSRFToken=" + ACC.config.CSRFToken, {
                             method: "POST",
                             headers: {
                                 "Content-Type": "application/json; charset=utf-8"
                             },
                             body:JSON.stringify("my-account")
                           })

                           const response = await result.json();
                           createVaultSetupTokenResponse = response;
                           return response.id
                       },

                       onApprove: async ({
                           vaultSetupToken
                       }) => {
                           const res = await fetch(ACC.config.encodedContextPath + "/paypal/vault/payment-token?CSRFToken=" + ACC.config.CSRFToken, {
                               method: "POST",
                               headers: {
                                   "Content-Type": "application/json; charset=utf-8"
                               },
                               body: JSON.stringify({
                                   "id": createVaultSetupTokenResponse.id,
                                   "customerId": createVaultSetupTokenResponse.customerId,
                                   "status": createVaultSetupTokenResponse.status,
                                   "selectedBillingAddress": "",
                                   "approveLink": createVaultSetupTokenResponse.approveLink,
                                   "paymentInfoPK": createVaultSetupTokenResponse.paymentInfoPK,
                               })
                           })

                           if (res.ok) {
                               window.location.replace(ACC.config.encodedContextPath + "/my-account/payment-details");
                               localStorage.setItem('savedPayPalPaymentMethodMessage', 'paypal.connect.saved.payment.method');
                           } else {
                               throw new Error();
                           }
                       },

                        onCancel: function (data) {
                           fetch(ACC.config.encodedContextPath + "/paypal/vault/payment-info?CSRFToken=" + ACC.config.CSRFToken, {
                               method: "DELETE",
                               headers: {
                                   "Content-Type": "application/json; charset=utf-8"
                               },
                               body: createVaultSetupTokenResponse.paymentInfoPK
                           })
                        },

                       onError: function(err) {
                           console.log(err);
                           ACC.paypalutil.handlePayPalClientError(PAYPAL_CONSTANTS.ERRORS.PAYPAL_CONNECT_SAVED_PAYMENT_METHOD);
                       }
                   }).render(container);
               } else {
                   console.log("Payment" + funding + " is not eligible");
               }
           },

        getButtonStyle: function (funding, buttonStyle) {
            let btnStyle = { ...buttonStyle }
            if (btnStyle != undefined && funding !== 'paypal' && funding !== 'paylater') {
                btnStyle.color = undefined;
            }
            return btnStyle;
        }
}