ACC.lpmchekout = {

    _autoload: [
        ["showLpmSelector", $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).length !== 0],
        ["renderLpmBtn", $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).length !== 0]
    ],

    renderLpmBtn: async function () {
        await ACC.paypalSDKloader.paypalSDKPromise;
        try {
            lpmFundingOnBillingPage.forEach(function(funding){
                ACC.lpmchekout.renderAdditionalFields(funding);
                ACC.paypalstandalonebutton.renderMarkButton(funding, PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER, PAYPAL_CONSTANTS.FLOWS.MARK_CHECKOUT);
            });
        } catch (err) {
            ACC.lpmchekout.handleError("lpm.button.render.error" + err.message);
        }
    },

    handleError: function (message) {
        $("#errorMessage span").text(message);
    },

    renderAdditionalFields: function (funding) {
        if (paypal.isFundingEligible(funding)) {
            paypal.PaymentFields({
                fundingSource: funding
            }).render(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER);
        }
    },

    showLpmSelector: function () {
        var lpmButtonsContainer = $(PAYPAL_CONSTANTS.LPM_BUTTONS_CONTAINER).get(0);
        new MutationObserver(() => {
            if (lpmButtonsContainer.hasChildNodes()) {
                $(PAYPAL_CONSTANTS.LPM_RADIO).closest("label").removeAttr("hidden");
            }
        }).observe(lpmButtonsContainer, {childList: true});
    }
}
