ACC.loadingSpinner = {

    spinner: $("<img>").attr("src", ACC.config.commonResourcePath + "/images/spinner.gif"),

    showSpinner: function(containerId, widthInPercent = PAYPAL_CONSTANTS.DEFAULT_SPINNER_SIZE) {
        const spinner = ACC.loadingSpinner.spinner[0];
        const cardDiv = document.getElementById(containerId);
        this.hideElements(cardDiv, true);
        this.addStyles(widthInPercent, spinner);
        cardDiv.appendChild(spinner);
    },

    hideSpinner: function (containerId) {
        const spinner = ACC.loadingSpinner.spinner[0];
        const cardDiv = document.getElementById(containerId);
        this.hideElements(cardDiv, false);
        cardDiv.removeChild(spinner);
    },

    addStyles: function (width, spinner) {
        spinner.style.margin = "auto";
        spinner.style.display = "block";
        spinner.style.width = width + "%";
    },

    hideElements: function (container, hide) {
        const childElements = container.childNodes;
        for (let i = 0; i < childElements.length; i++) {
            const child = childElements[i];
            if (child.nodeType === 1) {
                child.style.display = hide ? 'none' : '';
            }
        }
    }
}