<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="cms" uri="http://hybris.com/tld/cmstags" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="formElement" tagdir="/WEB-INF/tags/responsive/formElement" %>
<%@ taglib prefix="address" tagdir="/WEB-INF/tags/responsive/address" %>
<%@ taglib prefix="multi-checkout-paypal" tagdir="/WEB-INF/tags/addons/paypaladdon/responsive/checkout/multi" %>

<spring:url value="/paypal/checkout/hop/response" var="markProcessUrl"/>
<spring:url value="/paypal/checkout/hop/create-order" var="createOrderUrl"/>
<spring:url value="/paypal/billing-agreement/checkout/create-token" var="createBillingAgreementTokenUrl"/>
<spring:url value="/paypal/billing-agreement/checkout/response" var="billingAgreementProcessUrl"/>
<spring:url value="/" var="homeUrl"/>
<spring:theme code="paypal.button.render.error" var="buttonError"/>
<spring:theme code="wrong.sent.parameters" var="errorMessage"/>
<spring:theme code="error.on.paypal.side" var="paypalError"/>
<spring:url value="/paypal/checkout/hosted/response" var="hostedProcessUrl"/>
<spring:url value="/paypal/checkout/hosted/create-order" var="hostedCreateOrderUrl"/>


<link rel="stylesheet" type="text/css" href="https://www.paypalobjects.com/webstatic/en_US/developer/docs/css/cardfields.css"/>

<div>
<c:if test="${payPalPluginConfiguration.payPalConfigurationData.payPalEnable && not empty payPalPluginConfiguration.payPalConfigurationData.payPalFundingOnBillingPage}">
    <label hidden="hidden">
        <input id="paymentMethodPayPal" type="radio" name="paymentMethodSelection" value="paypal" />
        <img src="${media.url}" alt="${media.altText}"/>
        <span id="whatIsPayPalLink" style="padding-left: 10px;"><cms:component component="${link}"/></span>
    </label>

    <div id="mark-paypal-buttons-container" class="paypal-button-container-mark">
       <div id="mark-paypal-button-container"></div>
       <div id="mark-credit-button-container"></div>
       <div id="mark-paylater-button-container"></div>
       <div id="mark-card-button-container"></div>
    </div>

    <c:if test="${payPalPluginConfiguration.payPalConfigurationData.vaultEnabled && not isSavedPayPalAccountsAmountLimited}">
        <sec:authorize access="isFullyAuthenticated()">
            <div id="savePayPalPaymentInfo">
                <input type="checkbox" id="savePaymentInfoCheckbox"/>
                <label><spring:theme code="checkout.multi.paymentMethod.save.paypal"/></label>
            </div>
        </sec:authorize>
    </c:if>
</c:if>
<p>
    <c:if test="${payPalPluginConfiguration.applePayConfigurationData.enable}">
        <label id="applePayLabelContainer">
            <input id="applePay" type="radio" name="paymentMethodSelection" value="applepay"/>
            <label for="applePay" id="applePayLabelId" class="headline"><spring:theme
                code="checkout.multi.paymentMethod.addPaymentDetails.method.applePay"/></label>
        </label>
        <div id="applepay-mark-checkout-render-btn-container"></div>
    </c:if>
</p>
 <p>
    <c:if test="${payPalPluginConfiguration.hostedFieldsConfigurationData.enable}">
        <label>
            <input id="hostedFields" type="radio" name="paymentMethodSelection" value="hosted-fields"/>
            <label for="hostedFields" id="creditCardLabelId" class="headline"><spring:theme
                    code="checkout.multi.paymentMethod.addPaymentDetails.method.card"/></label>
            <c:if test="${payPalPluginConfiguration.hostedFieldsConfigurationData.vaultFlow && isSavedCreditCardsAmountLimited eq false}">
                <sec:authorize access="isFullyAuthenticated()">
                    <div id="saveHostedFieldPaymentInfo">
                        <input type="checkbox" id="saveHostedFieldsPaymentInfoCheckbox"/>
                        <label><spring:theme code="checkout.multi.sop.savePaymentInfo"/></label>
                    </div>
                </sec:authorize>
            </c:if>
        </label>

        <div id="hosted-button-container" class="checkout-next" style="text-align:left">
            <div class="card_container">
                <form:form id="card-form" onsubmit="return false;">
                    <label for="card-number">Card Number</label><div id="card-number" class="card_field"></div>
                    <div>
                        <label for="expiration-date">Expiration Date</label>
                        <div id="expiration-date" class="card_field"></div>
                    </div>
                    <div>
                        <label for="cvv">CVV</label><div id="cvv" class="card_field"></div>
                    </div>
                    <label for="card-holder-name">Name on Card</label>
                    <input type="text" id="card-holder-name" name="card-holder-name" autocomplete="off" placeholder="Cardholder name"/>
                    <div class="hosted-container-input">
                        <div class="hosted-input">
                            <input type="submit" value="Pay" id="submit" class="btn btn-block btn-default hosted-input">
                        </div>
                    </div>
                </form:form>

                <form:form id="silentOrderPostForm" name="silentOrderPostForm"
                           modelAttribute="sopPaymentDetailsForm"
                           action="${paymentFormUrl}" method="POST">
                    <div class="headline" style="text-align: center">
                        <spring:theme
                                code="checkout.multi.paymentMethod.addPaymentDetails.billingAddress"/>
                    </div>

                    <c:if test="${cartData.deliveryItemsQuantity > 0}">

                        <div id="useDeliveryAddressData"
                             data-titlecode="${fn:escapeXml(deliveryAddress.titleCode)}"
                             data-firstname="${fn:escapeXml(deliveryAddress.firstName)}"
                             data-lastname="${fn:escapeXml(deliveryAddress.lastName)}"
                             data-line1="${fn:escapeXml(deliveryAddress.line1)}"
                             data-line2="${fn:escapeXml(deliveryAddress.line2)}"
                             data-town="${fn:escapeXml(deliveryAddress.town)}"
                             data-postalcode="${fn:escapeXml(deliveryAddress.postalCode)}"
                             data-countryisocode="${fn:escapeXml(deliveryAddress.country.isocode)}"
                             data-regionisocode="${fn:escapeXml(deliveryAddress.region.isocodeShort)}"
                             data-address-id="${fn:escapeXml(deliveryAddress.id)}"
                        ></div>
                        <div id="useDeliveryAddressCheckbox" style="text-align:center">
                            <formElement:formCheckbox
                                    path="useDeliveryAddress"
                                    idKey="useDeliveryAddress"
                                    labelKey="checkout.multi.sop.useMyDeliveryAddress"
                                    tabindex="11"/>
                        </div>
                    </c:if>

                    <input type="hidden"
                           value="${fn:escapeXml(silentOrderPageData.parameters['billTo_email'])}"
                           class="text" name="billTo_email" id="billTo_email">
                    <div id="selectedAddress">
                        <multi-checkout-paypal:actualAddress/>
                    </div>
                    <div id="addressFields">
                        <address:billAddressFormSelector supportedCountries="${countries}"
                                                         regions="${regions}"
                                                         tabindex="12"/>
                    </div>
                    <p class="help-block"><spring:theme
                            code="checkout.multi.paymentMethod.seeOrderSummaryForMoreInformation"/></p>

                </form:form>

            </div>
        </div>
    </c:if>
 </p>

    <c:if test="${payPalPluginConfiguration.localPaymentsConfigurationData.enable}">
            <label hidden="hidden">
                <input id="lpmPayments" type="radio" name="paymentMethodSelection" value="lpm"/>
                <label for="lpmPayments" id="lpmPaymentsLabelId" class="headline"><spring:theme
                        code="checkout.multi.paymentMethod.addPaymentDetails.method.lpm"/></label>
            </label>
        </c:if>
</div>

<c:if test="${payPalPluginConfiguration.localPaymentsConfigurationData.enable}">
    <div id="lpm-buttons-container" class="checkout-next"></div>
</c:if>

<c:if test="${payPalPluginConfiguration.venmoConfigurationData.enable}">
    <label hidden="hidden">
        <input id="venmo" type="radio" name="paymentMethodSelection" value="venmo"/>
        <label for="venmo" id="venmoPaymentMethodId" class="headline"><spring:theme
            code="checkout.paymentMethod.venmo"/></label>
    </label>

    <div id="mark-venmo-button-container"></div>
</c:if>

<c:if test="${payPalPluginConfiguration.payPalGeneralConfigurationData.fraudNetIntegration}">
    <script type="application/json" fncls="fnparams-dede7cc5-15fd-4c75-a9f4-36c430ee3a99">
        {
            "f":"${correlationId}",
            "s":"${pageId}",
            "sandbox":${payPalPluginConfiguration.payPalGeneralConfigurationData.fraudNetSandbox}
        }
    </script>
    <script type="text/javascript" src="https://c.paypal.com/da/r/fb.js"></script>
</c:if>

<script>
    var hostedFieldsStylesConf = {
        inputColor: '${hostedFieldsStyles.inputColor}',
        validColor: '${hostedFieldsStyles.validColor}',
        invalidColor: '${hostedFieldsStyles.invalidColor}',
        fontSize: '${hostedFieldsStyles.fontSize}'
    }
    var paypalButtonConfig = {
        color:   '${paypalButtonConfig.color}',
        shape:   '${paypalButtonConfig.shape}',
        label:   '${paypalButtonConfig.label}',
        borderRadius: parseInt("${paypalButtonConfig.borderRadius}"),
        height:  parseInt('${paypalButtonConfig.height}')
    }

    var applePayButtonConfigMark = {
      buttonstyle:   '${applePayButtonConfigMark.color}',
      type:   '${applePayButtonConfigMark.type}',
    }

    var payPalFundingOnBillingPage = [];
    <c:forEach items='${payPalPluginConfiguration.payPalConfigurationData.payPalFundingOnBillingPage}' var='fund'>
        payPalFundingOnBillingPage.push('${fund}'.toLowerCase())
    </c:forEach>

    var lpmFundingOnBillingPage = [];
    <c:forEach items='${payPalPluginConfiguration.localPaymentsConfigurationData.fundingsOnBillingPage}' var='fund'>
        lpmFundingOnBillingPage.push('${fund}'.toLowerCase())
    </c:forEach>

    var isChangePaymentButtonEnabled = ${payPalPluginConfiguration.payPalConfigurationData.changePaymentButtonEnabled}
    var isPayPalEnable = ${payPalPluginConfiguration.payPalConfigurationData.payPalEnable}
</script>
