<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<c:if test="${isCreditMessagesEnabled}">

    <c:set var="componentColor" value="${fn:toLowerCase(fn:replace(component.color.code,'_', '-'))}"/>
    <div id="paypal-credit-message"
         data-pp-message data-pp-placement="${component.placement.code}"
         data-pp-amount="${totalPrice.value}"
         data-pp-style-layout="${component.layout.code}"
         data-pp-style-color="${componentColor}"
         data-pp-style-ratio="${component.ratio}"
         data-pp-style-logo-type="${component.logoType.code}"
         data-pp-style-logo-position="${component.logoPosition.code}"
         data-pp-style-text-color="${component.textColor.code}"
    ></div>

    <script>
        var target = document.getElementsByClassName("mini-cart-price")[0];
        var observer = new MutationObserver(function (mutations) {
            var totalPrice = target.innerHTML.trim().substr(1).replace(/,/g, '');
            document.getElementById("paypal-credit-message").setAttribute("data-pp-amount", totalPrice);
        });
        var config = {attributes: true, childList: true, characterData: true};
        observer.observe(target, config);
    </script>
</c:if>
