package com.paypal.hybris.addon.validators;

import com.paypal.hybris.addon.forms.CreditCardAddressForm;
import com.paypal.hybris.core.util.ExpiredDateValidatorUtil;
import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorstorefrontcommons.forms.UpdateEmailForm;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.validation.Errors;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PaypalExpiredDateValidatorTest {

    private static final String EXPIRY_YEAR = "expiryYear";
    private static final String EXPIRY_MONTH = "expiryMonth";
    private static final String CREDIT_CARD_EXPIRY_MONTH_INVALID = "credit.card.expiry.month.invalid";
    private static final String CREDIT_CARD_EXPIRY_YEAR_INVALID = "credit.card.expiry.year.invalid";

    @Mock
    private ExpiredDateValidatorUtil expiredDateValidatorUtil;

    @Mock
    private Errors errors;

    @InjectMocks
    private PaypalExpiredDateValidator unit;

    private CreditCardAddressForm creditCard;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);

        creditCard = new CreditCardAddressForm();
        creditCard.setExpiryMonth(EXPIRY_MONTH);
        creditCard.setExpiryYear(EXPIRY_YEAR);
    }

    @Test
    public void shouldSupportClass() {
        assertTrue(unit.supports(CreditCardAddressForm.class));
    }

    @Test
    public void shouldNotSupportClass() {
        assertFalse(unit.supports(UpdateEmailForm.class));
    }
    @Test
    public void shouldSuccessfullyValidate() {
        when(expiredDateValidatorUtil.getMonthsToExpiration(EXPIRY_MONTH, EXPIRY_YEAR)).thenReturn(5L);

        unit.validate(creditCard, errors);

        verify(errors, never()).rejectValue(EXPIRY_YEAR, CREDIT_CARD_EXPIRY_YEAR_INVALID);
        verify(errors, never()).rejectValue(EXPIRY_MONTH, CREDIT_CARD_EXPIRY_MONTH_INVALID);
    }

    @Test
    public void shouldValidateWithError() {
        when(expiredDateValidatorUtil.getMonthsToExpiration(EXPIRY_MONTH, EXPIRY_YEAR)).thenReturn(-1L);

        unit.validate(creditCard, errors);

        verify(errors).rejectValue(EXPIRY_YEAR, CREDIT_CARD_EXPIRY_YEAR_INVALID);
        verify(errors).rejectValue(EXPIRY_MONTH, CREDIT_CARD_EXPIRY_MONTH_INVALID);
    }
}