package com.paypal.hybris.addon.security.handler;

import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;

import static com.paypal.hybris.addon.constants.PaypaladdonWebConstants.CONNECT_LOGIN_ACCOUNT_CONNECT;
import static org.mockito.Mockito.verify;

@UnitTest
public class PasswordVerificationSuccessHandlerTest {

    @Mock
    private RedirectStrategy redirectStrategy;

    @Mock
    private HttpServletRequest request;

    @Mock
    private HttpServletResponse response;

    @Mock
    private Authentication authentication;

    @InjectMocks
    private PasswordVerificationSuccessHandler unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldRedirectAfterPasswordVerificationSuccess() throws IOException {
        unit.onAuthenticationSuccess(request, response, authentication);

        verify(redirectStrategy).sendRedirect(request, response, CONNECT_LOGIN_ACCOUNT_CONNECT);
    }
}