package com.paypal.hybris.addon.security.handler;

import de.hybris.bootstrap.annotations.UnitTest;
import de.hybris.platform.acceleratorstorefrontcommons.security.BruteForceAttackCounter;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import java.io.IOException;

import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@UnitTest
public class PasswordVerificationFailureHandlerTest {

    private static final String SPRING_SECURITY_LAST_USERNAME = "SPRING_SECURITY_LAST_USERNAME";
    private static final String J_USERNAME_PARAM = "j_username";

    @Mock
    private BruteForceAttackCounter bruteForceAttackCounter;

    @Mock
    private HttpServletRequest request;

    @Mock
    private HttpServletResponse response;

    @Mock
    private AuthenticationException exception;

    @Mock
    private HttpSession session;

    @InjectMocks
    private PasswordVerificationFailureHandler unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldHandleAuthenticationFailure() throws IOException, ServletException {
        when(request.getParameter(J_USERNAME_PARAM)).thenReturn(J_USERNAME_PARAM);
        when(request.getSession()).thenReturn(session);
        doNothing().when(bruteForceAttackCounter).registerLoginFailure(J_USERNAME_PARAM);

        unit.onAuthenticationFailure(request, response, exception);

        verify(response).sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
    }
}