package com.paypal.hybris.addon.security;

import de.hybris.bootstrap.annotations.UnitTest;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

import static de.hybris.platform.testframework.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThrows;

@UnitTest
public class ConnectWithPayPalAuthenticationTokenTest {

    public static final String EMAIL = "user@example.com";

    @Test
    public void shouldSetPrincipalWhenValid() {
        Object validPrincipal = EMAIL;

        ConnectWithPayPalAuthenticationToken token = new ConnectWithPayPalAuthenticationToken(validPrincipal);

        assertEquals(validPrincipal, token.getPrincipal());
        assertFalse(token.isAuthenticated());
    }

    @Test
    public void shouldThrowExceptionWhenPrincipalIsNull() {
        assertThrows(IllegalArgumentException.class, () -> {
            new ConnectWithPayPalAuthenticationToken(null);
        });
    }

    @Test
    public void shouldThrowExceptionWhenPrincipalIsEmptyString() {
        assertThrows(IllegalArgumentException.class, () -> {
            new ConnectWithPayPalAuthenticationToken(StringUtils.EMPTY);
        });
    }
}