package com.paypal.hybris.addon.security.handler;

import de.hybris.platform.acceleratorstorefrontcommons.security.BruteForceAttackCounter;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class PasswordVerificationFailureHandler extends SimpleUrlAuthenticationFailureHandler {

    private static final String SPRING_SECURITY_LAST_USERNAME = "SPRING_SECURITY_LAST_USERNAME";
    private static final String J_USERNAME_PARAM = "j_username";
    private BruteForceAttackCounter bruteForceAttackCounter;

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
                                        AuthenticationException exception) throws IOException, ServletException {
        bruteForceAttackCounter.registerLoginFailure(request.getParameter(J_USERNAME_PARAM));
        request.getSession().setAttribute(SPRING_SECURITY_LAST_USERNAME, request.getParameter(J_USERNAME_PARAM));
        super.onAuthenticationFailure(request, response, exception);
    }

    public void setBruteForceAttackCounter(BruteForceAttackCounter bruteForceAttackCounter) {
        this.bruteForceAttackCounter = bruteForceAttackCounter;
    }
}
