package com.paypal.hybris.addon.controllers.pages;

import com.paypal.enums.PayPalPaymentProvider;
import com.paypal.hybris.addon.forms.CCSetupTokenData;
import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.core.service.PayPalPaymentInfoService;
import com.paypal.hybris.data.SetupTokenRequestData;
import com.paypal.hybris.facade.facades.impl.DefaultPayPalCreditCardFacade;
import de.hybris.platform.servicelayer.session.SessionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping(value = "/paypal/vault")
public class PayPalPaymentMethodController {

    private static final String PAYER_ID = "payerId";
    private static final String LOGIN_PAGE = "login";

    @Resource
    private DefaultPayPalCreditCardFacade payPalCreditCardFacade;
    @Resource
    private PayPalPaymentInfoService payPalPaymentInfoService;
    @Resource
    private SessionService sessionService;

    @RequestMapping(value = "/setup-token", method = RequestMethod.POST)
    public ResponseEntity<CCSetupTokenData> createVaultSetupToken(@RequestBody String pageType) {
        SetupTokenRequestData setupTokenRequestData = new SetupTokenRequestData();
        setupTokenRequestData.setPaymentType(PayPalPaymentProvider.PAYPAL);
        if (LOGIN_PAGE.equals(pageType)) {
            setupTokenRequestData.setPayerId(sessionService.getAttribute(PAYER_ID));
        }

        CCSetupTokenData ccSetupTokenData = payPalCreditCardFacade.requestSetupToken(setupTokenRequestData);
        return ResponseEntity.ok(ccSetupTokenData);
    }

    @RequestMapping(value = "/payment-token", method = RequestMethod.POST)
    public ResponseEntity<String> createVaultPaymentToken(@RequestBody final CCSetupTokenData setupTokenData) {
        PaymentTokenData paymentTokenData = preparePaypalTokenDataForRequest(setupTokenData);
        try {
            payPalCreditCardFacade.requestPaymentToken(paymentTokenData);
        } catch (Exception e) {
            return new ResponseEntity<>(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @RequestMapping(value = "/payment-info", method = RequestMethod.DELETE)
    public ResponseEntity<String> removePaymentInfoByPk(@RequestBody final String paymentInfoPk) {
        payPalPaymentInfoService.removePaymentInfoByPK(paymentInfoPk);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    private PaymentTokenData preparePaypalTokenDataForRequest(CCSetupTokenData ccSetupTokenData) {
        PaymentTokenData paymentTokenData = new PaymentTokenData();
        paymentTokenData.setSetupToken(ccSetupTokenData.getId());
        paymentTokenData.setAddressId(ccSetupTokenData.getSelectedBillingAddress());
        paymentTokenData.setPaymentInfoPK(ccSetupTokenData.getPaymentInfoPK());
        paymentTokenData.setCustomerId(ccSetupTokenData.getCustomerId());

        return paymentTokenData;
    }
}

