package com.paypal.hybris.addon.controllers.pages;

import com.paypal.hybris.addon.controllers.PaypaladdonControllerConstants;
import com.paypal.hybris.facade.facades.PayPalCustomerFacade;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractLoginPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.pages.AbstractRegisterPageController;
import de.hybris.platform.acceleratorstorefrontcommons.controllers.util.GlobalMessages;
import de.hybris.platform.acceleratorstorefrontcommons.forms.GuestForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.LoginForm;
import de.hybris.platform.acceleratorstorefrontcommons.forms.RegisterForm;
import de.hybris.platform.cms2.exceptions.CMSItemNotFoundException;
import de.hybris.platform.cms2.model.pages.AbstractPageModel;
import de.hybris.platform.servicelayer.user.UserService;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;


@Controller
@RequestMapping(value = "/login")
public class PayPalLoginPageController extends AbstractLoginPageController {

    private static final Logger LOGGER = Logger.getLogger(AbstractRegisterPageController.class);
    private static final String FORM_GLOBAL_ERROR = "form.global.error";

    private HttpSessionRequestCache httpSessionRequestCache;

    @Resource(name = "defaultUserService")
    private UserService userService;

    @Resource(name = "payPalCustomerFacade")
    private PayPalCustomerFacade payPalCustomerFacade;

    @Override
    protected String getView()
    {
        return PaypaladdonControllerConstants.Views.Pages.Account.ACCOUNT_LOGIN_PAGE;
    }

    @Override
    protected String getSuccessRedirect(final HttpServletRequest request, final HttpServletResponse response) {
        if (httpSessionRequestCache.getRequest(request, response) != null)
        {
            return httpSessionRequestCache.getRequest(request, response).getRedirectUrl();
        }
        return "/";
    }

    @Override
    protected AbstractPageModel getCmsPage() throws CMSItemNotFoundException {
        return getContentPageForLabelOrId("login");
    }


    @Resource(name = "httpSessionRequestCache")
    public void setHttpSessionRequestCache(final HttpSessionRequestCache accHttpSessionRequestCache) {
        this.httpSessionRequestCache = accHttpSessionRequestCache;
    }

    @RequestMapping(value = "/customerRegistration", method = RequestMethod.POST)
    public String doRegister(@RequestHeader(value = "referer", required = false) final String referer,
                             final RegisterForm form, final BindingResult bindingResult, final Model model,
                             final HttpServletRequest request, final HttpServletResponse response,
                             final RedirectAttributes redirectModel) throws CMSItemNotFoundException {
        getRegistrationValidator().validate(form, bindingResult);
        if (!bindingResult.hasErrors() && userService.isUserExisting(form.getEmail().toLowerCase())
                && payPalCustomerFacade.isPayerIdInCustomer(form.getEmail().toLowerCase())) {
            LOGGER.debug("registration failed.");
            form.setTermsCheck(false);
            model.addAttribute(form);
            model.addAttribute(new LoginForm());
            model.addAttribute(new GuestForm());
            bindingResult.rejectValue("email", "paypal.connect.registration.payerId.global.error");
            GlobalMessages.addErrorMessage(model, FORM_GLOBAL_ERROR);
            return handleRegistrationError(model);
        }
        return processRegisterUserRequest(referer, form, bindingResult, model, request, response, redirectModel);
    }
}
