/*
 * [y] hybris Platform
 *
 * Copyright (c) 2018 SAP SE or an SAP affiliate company.  All rights reserved.
 *
 * This software is the confidential and proprietary information of SAP
 * ("Confidential Information"). You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms of the
 * license agreement you entered into with SAP.
 */
package com.paypal.hybris.addon.controllers;

import com.paypal.hybris.addon.model.PayPalButtonComponentModel;
import com.paypal.hybris.addon.model.PayPalConnectButtonComponentModel;
import com.paypal.hybris.addon.model.PayPalCreditMessageComponentModel;
import com.paypal.hybris.addon.model.PayPalMiniCartComponentModel;

import static com.paypal.hybris.addon.constants.PaypaladdonConstants.EXTENSIONNAME;


public interface PaypaladdonControllerConstants {

    String ADDON_PREFIX = "addon:/" + EXTENSIONNAME + "/";

    interface Actions {

        interface Cms {

            String PREFIX = "/view/";
            String SUFFIX = "Controller";

            String PAYPAL_MINI_CART_COMPONENT = PREFIX + PayPalMiniCartComponentModel._TYPECODE + SUFFIX;

            String PAYPAL_CREDIT_MESSAGE_COMPONENT = PREFIX + PayPalCreditMessageComponentModel._TYPECODE + SUFFIX;

            String PAYPAL_BUTTON_COMPONENT = PREFIX + PayPalButtonComponentModel._TYPECODE + SUFFIX;

            String PAYPAL_CONNECT_BUTTON_COMPONENT = PREFIX + PayPalConnectButtonComponentModel._TYPECODE + SUFFIX;
        }
    }

    interface Views {

        interface Pages {

            interface MultiStepCheckout {

                String SILENT_ORDER_POST_PAGE = ADDON_PREFIX + "pages/checkout/multi/silentOrderPostPage";
                String CHECKOUT_SUMMARY_PAGE = ADDON_PREFIX + "pages/checkout/multi/checkoutSummaryPage";
            }

            interface Checkout {

                String CHECKOUT_SUMMARY_PAGE = "pages/checkout/multi/checkoutSummaryPage";
                String CHECKOUT_LOGIN_PAGE = "pages/checkout/checkoutLoginPage";
                String CHECKOUT_CONFIRMATION_PAGE_URL = "pages/checkout/checkoutConfirmationPage";
                String CHECKOUT_CONFIRMATION_PAGE = ADDON_PREFIX + "pages/checkout/checkoutConfirmationPage";
            }

            interface Account {

                String ACCOUNT_LOGIN_PAGE = "pages/account/accountLoginPage";
            }

            interface Login {
                String SAVE_PAYMENT_INFO_PAGE = ADDON_PREFIX + "pages/login/savePaymentInfo";
                String ACCOUNT_CONNECT_PASSWORD_VERIFICATION_PAGE = ADDON_PREFIX + "pages/login/accountConnectPasswordVerificationPage";
            }
        }

        interface Fragments {

            interface Cart {

                String CART_POPUP = ADDON_PREFIX + "fragments/cart/cartPopup";
                String ADD_TO_CART_POPUP = ADDON_PREFIX + "fragments/cart/addToCartPopup";
            }
        }
    }
}
