package com.paypalocc.populators;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.data.ws.PayPalCCSetupTokenWsDTO;
import de.hybris.bootstrap.annotations.UnitTest;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import static org.junit.Assert.assertEquals;

@UnitTest
public class PaymentTokenDataPopulatorTest {

    private static final String ID = "id";
    private static final String ADDRESS_ID = "addressId";
    private static final String PK = "pk";
    private static final String CUSTOMER_ID = "customerId";

    @InjectMocks
    private PaymentTokenDataPopulator unit;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks(this);
    }

    @Test
    public void shouldPopulateData() {
        PayPalCCSetupTokenWsDTO source = getSource();
        PaymentTokenData target = new PaymentTokenData();

        unit.populate(source, target);

        assertEquals(ID, target.getSetupToken());
        assertEquals(ADDRESS_ID, target.getAddressId());
        assertEquals(PK, target.getPaymentInfoPK());
        assertEquals(CUSTOMER_ID, target.getCustomerId());
    }

    private static PayPalCCSetupTokenWsDTO getSource() {
        PayPalCCSetupTokenWsDTO source = new PayPalCCSetupTokenWsDTO();
        source.setId(ID);
        source.setSelectedBillingAddress(ADDRESS_ID);
        source.setPaymentInfoPK(PK);
        source.setCustomerId(CUSTOMER_ID);
        return source;
    }

}