package com.paypalocc.populators;

import com.paypal.hybris.data.ApplePayAddressDetailsData;
import com.paypal.hybris.data.ws.ApplePayAddressDetailsWsData;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.MockitoAnnotations;

import java.util.ArrayList;
import java.util.List;

import static org.junit.Assert.assertEquals;

public class ApplePayWsDataPopulatorTest {

    private static final String LINE_1 = "line1";
    private static final String LINE_2 = "line2";
    private static final String ADMINISTRATIVE_AREA = "administrativeArea";
    private static final String COUNTRY = "country";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String EMAIL_ADDRESS = "emailAddress";
    private static final String FAMILY_NAME = "familyName";
    private static final String GIVEN_NAME = "givenName";
    private static final String LOCALITY = "locality";
    private static final String PHONE_NUMBER = "phoneNumber";
    private static final String POSTAL_CODE = "postalCode";

    @InjectMocks
    private ApplePayWsDataPopulator unit;

    private ApplePayAddressDetailsWsData source;

    private ApplePayAddressDetailsData target;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks(this);

        source = new ApplePayAddressDetailsWsData();
        target = new ApplePayAddressDetailsData();

        source.setAddressLines(new ArrayList<>(List.of(LINE_1, LINE_2)));
        source.setAdministrativeArea(ADMINISTRATIVE_AREA);
        source.setCountry(COUNTRY);
        source.setCountryCode(COUNTRY_CODE);
        source.setEmailAddress(EMAIL_ADDRESS);
        source.setFamilyName(FAMILY_NAME);
        source.setGivenName(GIVEN_NAME);
        source.setLocality(LOCALITY);
        source.setPhoneNumber(PHONE_NUMBER);
        source.setPostalCode(POSTAL_CODE);
    }


    @Test
    public void shouldPopulateAddressWsDataToAddressData() {
        unit.populate(source, target);

        assertEquals(new ArrayList<>(List.of(LINE_1, LINE_2)), target.getAddressLines());
        assertEquals(ADMINISTRATIVE_AREA, target.getAdministrativeArea());
        assertEquals(COUNTRY, target.getCountry());
        assertEquals(COUNTRY_CODE, target.getCountryCode());
        assertEquals(EMAIL_ADDRESS, target.getEmailAddress());
        assertEquals(FAMILY_NAME, target.getFamilyName());
        assertEquals(GIVEN_NAME, target.getGivenName());
        assertEquals(LOCALITY, target.getLocality());
        assertEquals(PHONE_NUMBER, target.getPhoneNumber());
        assertEquals(POSTAL_CODE, target.getPostalCode());
    }
}