package com.paypalocc.populators;

import com.paypal.hybris.addon.forms.PaymentTokenData;
import com.paypal.hybris.data.ws.PayPalCCSetupTokenWsDTO;
import de.hybris.platform.converters.Populator;
import de.hybris.platform.servicelayer.dto.converter.ConversionException;
import org.springframework.util.Assert;

public class PaymentTokenDataPopulator implements Populator<PayPalCCSetupTokenWsDTO, PaymentTokenData> {

    @Override
    public void populate(PayPalCCSetupTokenWsDTO source, PaymentTokenData target) throws ConversionException {
        Assert.notNull(source, "Parameter source cannot be null.");
        Assert.notNull(target, "Parameter target cannot be null.");

        target.setSetupToken(source.getId());
        target.setCustomerId(source.getCustomerId());
        target.setAddressId(source.getSelectedBillingAddress());
        target.setPaymentInfoPK(source.getPaymentInfoPK());
    }

}
