package com.paypalocc.controllers;

import com.paypal.hybris.facade.facades.PayPalSessionPaymentMethodFacade;
import de.hybris.platform.commercefacades.order.data.CCPaymentInfoData;
import de.hybris.platform.commercewebservicescommons.dto.order.PaymentDetailsWsDTO;
import de.hybris.platform.webservicescommons.swagger.ApiBaseSiteIdUserIdAndCartIdParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.paypal.hybris.data.SessionPaymentValidationData;
import de.hybris.platform.commercewebservicescommons.dto.order.SessionPaymentValidationWsDTO;

import javax.annotation.Resource;

@RestController
@RequestMapping(value = "/{baseSiteId}")
public class PayPalSessionPaymentController extends PayPalBaseController {

    @Resource(name = "payPalSessionPaymentMethodFacade")
    private PayPalSessionPaymentMethodFacade payPalSessionPaymentMethodFacade;


    @GetMapping("/users/{userId}/carts/{cartId}/paypal/sessionPayment")
    @ResponseStatus(HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdUserIdAndCartIdParam
    @ApiOperation("Get Session Payment")
    public PaymentDetailsWsDTO getPayPalSessionPayment() {
        final CCPaymentInfoData sessionPaymentInfo = payPalSessionPaymentMethodFacade.getSessionPaymentMethod();
        return getDataMapper().map(sessionPaymentInfo, PaymentDetailsWsDTO.class);
    }

    @GetMapping("/users/{userId}/carts/{cartId}/paypal/sessionPayment/validation")
    @ResponseStatus(HttpStatus.OK)
    @ResponseBody
    @ApiBaseSiteIdUserIdAndCartIdParam
    @ApiOperation("Validate Session Payment")
    public SessionPaymentValidationWsDTO validatePayPalSessionPayment() {
        return getDataMapper().map(createAndPopulatePaymentValidationData(), SessionPaymentValidationWsDTO.class);
    }

    private SessionPaymentValidationData createAndPopulatePaymentValidationData() {
        final SessionPaymentValidationData validationData = new SessionPaymentValidationData();
        validationData.setIsValid(payPalSessionPaymentMethodFacade.isPaymentMethodValid());
        validationData.setIsEnabled(payPalSessionPaymentMethodFacade.isSessionPaymentFlowEnable());
        validationData.setIsEligible(payPalSessionPaymentMethodFacade.isPaymentMethodTypeEligible());
        return validationData;
    }
}
